/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.signup;

import java.util.HashMap;
import org.eclipse.vorto.repository.internal.service.notification.IMessage;
import org.eclipse.vorto.repository.internal.service.notification.INotificationService;
import org.eclipse.vorto.repository.internal.service.notification.message.RegistrationMessage;
import org.eclipse.vorto.repository.model.Role;
import org.eclipse.vorto.repository.model.User;
import org.eclipse.vorto.repository.model.UserDto;
import org.eclipse.vorto.repository.service.IRegistrationService;
import org.eclipse.vorto.repository.service.IUserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRegistrationService
implements IRegistrationService {
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private INotificationService notificationService;

    public INotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(INotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void registerUser(UserDto userDto) {
        User user = new User();
        user.setFirstName(userDto.getFirstName());
        user.setLastName(userDto.getLastName());
        user.setUsername(userDto.getUsername().toLowerCase());
        user.setPassword(userDto.getPassword());
        user.setHasWatchOnRepository(false);
        user.setEmail(userDto.getEmail());
        user.setRoles(Role.USER);
        User registered = (User)this.userRepository.save((Object)user);
        this.notifyUser(registered);
    }

    public void notifyUser(User user) {
        HashMap<String, User> context = new HashMap<String, User>(1);
        context.put("user", user);
        this.notificationService.sendNotification((IMessage)new RegistrationMessage(user));
    }
}

