/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.api.upload.UploadModelResult;
import org.eclipse.vorto.repository.internal.model.DefaultModelContent;
import org.eclipse.vorto.repository.internal.model.ModelEMFResource;
import org.eclipse.vorto.repository.internal.service.ITemporaryStorage;
import org.eclipse.vorto.repository.internal.service.ModelParserFactory;
import org.eclipse.vorto.repository.internal.service.StorageItem;
import org.eclipse.vorto.repository.internal.service.UploadModelResultFactory;
import org.eclipse.vorto.repository.internal.service.notification.IMessage;
import org.eclipse.vorto.repository.internal.service.notification.INotificationService;
import org.eclipse.vorto.repository.internal.service.notification.message.CheckinMessage;
import org.eclipse.vorto.repository.internal.service.utils.ModelIdHelper;
import org.eclipse.vorto.repository.internal.service.utils.ModelReferencesHelper;
import org.eclipse.vorto.repository.internal.service.utils.ModelSearchUtil;
import org.eclipse.vorto.repository.internal.service.validation.DuplicateModelValidation;
import org.eclipse.vorto.repository.internal.service.validation.IModelValidator;
import org.eclipse.vorto.repository.internal.service.validation.ModelReferencesValidation;
import org.eclipse.vorto.repository.internal.service.validation.ValidationException;
import org.eclipse.vorto.repository.model.IModelContent;
import org.eclipse.vorto.repository.model.User;
import org.eclipse.vorto.repository.service.FatalModelRepositoryException;
import org.eclipse.vorto.repository.service.IModelRepository;
import org.eclipse.vorto.repository.service.IUserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JcrModelRepository
implements IModelRepository {
    public static final long TTL_TEMP_STORAGE_INSECONDS = 300L;
    @Autowired
    private Session session;
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private ModelSearchUtil modelSearchUtil;
    @Autowired
    private INotificationService notificationService;
    @Autowired
    private ITemporaryStorage uploadStorage;
    private List<IModelValidator> validators = new LinkedList();
    private static Logger logger = Logger.getLogger(JcrModelRepository.class);

    public List<ModelInfo> search(String expression) {
        String queryExpression = expression;
        if (queryExpression == null || queryExpression.isEmpty()) {
            queryExpression = "*";
        }
        try {
            ArrayList<ModelInfo> modelResources = new ArrayList<ModelInfo>();
            Query query = this.modelSearchUtil.createQueryFromExpression(this.session, queryExpression);
            logger.debug((Object)("Searching repository with expression " + query.getStatement()));
            QueryResult result = query.execute();
            RowIterator rowIterator = result.getRows();
            while (rowIterator.hasNext()) {
                Row row = rowIterator.nextRow();
                Node currentNode = row.getNode();
                if (!currentNode.hasProperty("vorto:type")) continue;
                try {
                    modelResources.add(this.createModelResource(currentNode));
                }
                catch (Exception exception) {}
            }
            return modelResources;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Could not create query manager", e);
        }
    }

    private ModelInfo createModelResource(Node node) throws RepositoryException {
        ModelInfo resource = new ModelInfo(ModelIdHelper.fromPath((String)node.getParent().getPath()), ModelType.valueOf((String)node.getProperty("vorto:type").getString()));
        resource.setDescription(node.getProperty("vorto:description").getString());
        resource.setDisplayName(node.getProperty("vorto:displayname").getString());
        resource.setCreationDate(node.getProperty("jcr:created").getDate().getTime());
        if (node.hasProperty("vorto:author")) {
            resource.setAuthor(node.getProperty("vorto:author").getString());
        }
        if (node.hasProperty("vorto:references")) {
            Value[] referenceValues = null;
            try {
                referenceValues = node.getProperty("vorto:references").getValues();
            }
            catch (Exception ex) {
                referenceValues = new Value[]{node.getProperty("vorto:references").getValue()};
            }
            if (referenceValues != null) {
                ModelReferencesHelper referenceHelper = new ModelReferencesHelper();
                for (Value referValue : referenceValues) {
                    String nodeUuid = referValue.getString();
                    Node referencedNode = this.session.getNodeByIdentifier(nodeUuid);
                    referenceHelper.addModelReference(ModelIdHelper.fromPath((String)referencedNode.getParent().getPath()).getPrettyFormat());
                }
                resource.setReferences(referenceHelper.getReferences());
            }
        }
        PropertyIterator propIter = node.getReferences();
        while (propIter.hasNext()) {
            Property prop = propIter.nextProperty();
            Node referencedByFileNode = prop.getParent();
            ModelId referencedById = ModelIdHelper.fromPath((String)referencedByFileNode.getParent().getPath());
            resource.getReferencedBy().add(referencedById);
        }
        NodeIterator imageNodeIterator = node.getParent().getNodes("img.png*");
        if (imageNodeIterator.hasNext()) {
            resource.setHasImage(true);
        }
        return resource;
    }

    public IModelContent getModelContent(ModelId modelId, IModelRepository.ContentType contentType) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node fileNode = (Node)folderNode.getNodes(modelId.getName() + "*").next();
            Node fileItem = (Node)fileNode.getPrimaryItem();
            InputStream is = fileItem.getProperty("jcr:data").getBinary().getStream();
            ModelEMFResource resource = (ModelEMFResource)ModelParserFactory.getParser((String)fileNode.getName()).parse(is);
            if (contentType == IModelRepository.ContentType.XMI) {
                return new DefaultModelContent(resource.getModel(), contentType, resource.toXMI());
            }
            return new DefaultModelContent(resource.getModel(), contentType, resource.toDSL());
        }
        catch (PathNotFoundException e) {
            throw new ModelNotFoundException("Could not find model with the given model id", (Throwable)e);
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Something went wrong accessing the repository", (Throwable)e);
        }
    }

    public UploadModelResult upload(byte[] content, String fileName) {
        try {
            ModelInfo resource = ModelParserFactory.getParser((String)fileName).parse((InputStream)new ByteArrayInputStream(content));
            ArrayList<ValidationException> validationExceptions = new ArrayList<ValidationException>();
            for (IModelValidator validator : this.validators) {
                try {
                    validator.validate(resource);
                }
                catch (ValidationException validationException) {
                    validationExceptions.add(validationException);
                }
            }
            if (validationExceptions.size() <= 0) {
                return UploadModelResult.valid((String)this.createUploadHandle(content, resource.getType()), (ModelInfo)resource);
            }
            return UploadModelResultFactory.create((ValidationException[])validationExceptions.toArray(new ValidationException[validationExceptions.size()]));
        }
        catch (ValidationException e) {
            return UploadModelResultFactory.invalid((ValidationException)e);
        }
    }

    private String createUploadHandle(byte[] content, ModelType type) {
        String handleId = UUID.randomUUID().toString() + type.getExtension();
        return this.uploadStorage.store(handleId, (Object)content, 300L).getKey();
    }

    public void checkin(String handleId, String author) {
        StorageItem uploadedItem = this.uploadStorage.get(handleId);
        if (uploadedItem == null) {
            throw new IllegalArgumentException("No model found for handleId '" + handleId + "'");
        }
        ModelInfo resource = ModelParserFactory.getParser((String)handleId).parse((InputStream)new ByteArrayInputStream((byte[])uploadedItem.getValue()));
        try {
            Node folderNode = this.createNodeForModelId(resource.getId());
            Node fileNode = folderNode.addNode(resource.getId().getName() + resource.getType().getExtension(), "nt:file");
            fileNode.addMixin("vorto:meta");
            fileNode.addMixin("mix:referenceable");
            fileNode.setProperty("vorto:author", author);
            Node contentNode = fileNode.addNode("jcr:content", "nt:resource");
            Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream((byte[])uploadedItem.getValue()));
            contentNode.setProperty("jcr:data", binary);
            this.session.save();
            logger.info((Object)"Checkin successful");
            this.uploadStorage.remove(handleId);
            this.notifyWatchers(resource, author);
        }
        catch (Exception e) {
            logger.error((Object)"Error checking in model", (Throwable)e);
            throw new FatalModelRepositoryException("Problem checking in uploaded model" + resource.getId(), (Throwable)e);
        }
    }

    private void notifyWatchers(ModelInfo resource, String author) {
        resource.setAuthor(author);
        for (User recipient : this.userRepository.findAll()) {
            if (!recipient.getHasWatchOnRepository()) continue;
            HashMap<String, Object> context = new HashMap<String, Object>(2);
            context.put("user", recipient);
            context.put("model", resource);
            this.notificationService.sendNotification((IMessage)new CheckinMessage(recipient, resource));
        }
    }

    private Node createNodeForModelId(ModelId id) throws RepositoryException {
        ModelIdHelper modelIdHelper = new ModelIdHelper(id);
        StringBuilder pathBuilder = new StringBuilder();
        Iterator modelIdIterator = modelIdHelper.iterator();
        Node rootNode = this.session.getRootNode();
        while (modelIdIterator.hasNext()) {
            String nextPathFragment = (String)modelIdIterator.next();
            pathBuilder.append(nextPathFragment).append("/");
            try {
                rootNode.getNode(pathBuilder.toString());
            }
            catch (PathNotFoundException pathNotFound) {
                Node addedNode = rootNode.addNode(pathBuilder.toString(), "nt:folder");
                addedNode.setPrimaryType("nt:folder");
            }
        }
        return rootNode.getNode(modelIdHelper.getFullPath().substring(1));
    }

    public ModelInfo getById(ModelId modelId) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node modelFileNode = folderNode.getNodes("*.type | *.fbmodel | *.infomodel | *.mapping").nextNode();
            ModelInfo modelResource = this.createModelResource(modelFileNode);
            if (modelResource.getType() == ModelType.InformationModel) {
                NodeIterator imageNodeIterator = folderNode.getNodes("img.png*");
                if (imageNodeIterator.hasNext()) {
                    modelResource.setHasImage(true);
                }
                for (ModelId referencedById : modelResource.getReferencedBy()) {
                    ModelEMFResource emfResource = this.getEMFResource(referencedById);
                    modelResource.addTargetPlatform(emfResource.getTargetPlatform());
                }
            }
            return modelResource;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Retrieving Content of Resource: Problem accessing repository", e);
        }
    }

    @PostConstruct
    public void createValidators() {
        this.validators.add(new DuplicateModelValidation((IModelRepository)this));
        this.validators.add(new ModelReferencesValidation((IModelRepository)this));
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public List<ModelInfo> getMappingModelsForTargetPlatform(ModelId modelId, String targetPlatform) {
        ArrayList<ModelInfo> mappingResources = new ArrayList<ModelInfo>();
        ModelInfo modelResource = this.getById(modelId);
        if (modelResource != null) {
            for (ModelId referenceeModelId : modelResource.getReferencedBy()) {
                ModelInfo referenceeModelResources = this.getById(referenceeModelId);
                if (referenceeModelResources.getType() != ModelType.Mapping || !this.isTargetPlatformMapping(referenceeModelResources, targetPlatform)) continue;
                mappingResources.add(referenceeModelResources);
            }
            for (ModelId referencedModelId : modelResource.getReferences()) {
                mappingResources.addAll(this.getMappingModelsForTargetPlatform(referencedModelId, targetPlatform));
            }
        }
        return mappingResources;
    }

    private boolean isTargetPlatformMapping(ModelInfo model, String targetPlatform) {
        try {
            ModelEMFResource emfResource = this.getEMFResource(model.getId());
            return emfResource.matchesTargetPlatform(targetPlatform);
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Something went wrong accessing the repository", (Throwable)e);
        }
    }

    private ModelEMFResource getEMFResource(ModelId modelId) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node fileNode = (Node)folderNode.getNodes().next();
            Node fileItem = (Node)fileNode.getPrimaryItem();
            InputStream is = fileItem.getProperty("jcr:data").getBinary().getStream();
            return (ModelEMFResource)ModelParserFactory.getParser((String)fileNode.getName()).parse(is);
        }
        catch (Exception e) {
            throw new FatalModelRepositoryException("Something went wrong accessing the repository", (Throwable)e);
        }
    }

    public void addModelImage(ModelId modelId, byte[] imageContent) {
        try {
            Node imageNode;
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node modelFolderNode = this.session.getNode(modelIdHelper.getFullPath());
            Node contentNode = null;
            if (modelFolderNode.hasNode("img.png")) {
                imageNode = modelFolderNode.getNode("img.png");
                contentNode = (Node)imageNode.getPrimaryItem();
            } else {
                imageNode = modelFolderNode.addNode("img.png", "nt:file");
                contentNode = imageNode.addNode("jcr:content", "nt:resource");
            }
            Binary binary = this.session.getValueFactory().createBinary((InputStream)new ByteArrayInputStream(imageContent));
            contentNode.setProperty("jcr:data", binary);
            this.session.save();
        }
        catch (PathNotFoundException e) {
            throw new ModelNotFoundException("Problem when trying to add image to model", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Something severe went wrong when accessing the repository", (Throwable)e);
        }
    }

    public byte[] getModelImage(ModelId modelId) {
        try {
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Node folderNode = this.session.getNode(modelIdHelper.getFullPath());
            if (folderNode.hasNode("img.png")) {
                Node imageNode = folderNode.getNode("img.png");
                Node fileItem = (Node)imageNode.getPrimaryItem();
                InputStream is = fileItem.getProperty("jcr:data").getBinary().getStream();
                return IOUtils.toByteArray((InputStream)is);
            }
        }
        catch (PathNotFoundException e) {
            throw new ModelNotFoundException("Problem when trying to retrieve image for model", (Throwable)e);
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Something severe went wrong when accessing the repository", (Throwable)e);
        }
        catch (IOException e) {
            throw new FatalModelRepositoryException("Something severe went wrong when trying to read image content", (Throwable)e);
        }
        return null;
    }

    public ModelSearchUtil getModelSearchUtil() {
        return this.modelSearchUtil;
    }

    public void setModelSearchUtil(ModelSearchUtil modelSearchUtil) {
        this.modelSearchUtil = modelSearchUtil;
    }

    public IUserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(IUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public INotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(INotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public ITemporaryStorage getUploadStorage() {
        return this.uploadStorage;
    }

    public void setUploadStorage(ITemporaryStorage uploadStorage) {
        this.uploadStorage = uploadStorage;
    }
}

