/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.repository.api.AbstractModel;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.service.IModelRepository;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.ModelDtoFactory;
import org.eclipse.vorto.server.commons.ModelZipFileExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="/find", description="Find information models")
@RestController
@RequestMapping(value={"/rest/model"})
public class ModelRepositoryController
extends AbstractRepositoryController {
    private static final String ATTACHMENT_FILENAME = "attachment; filename = ";
    private static final String XMI = ".xmi";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION = "content-disposition";
    @Autowired
    private IModelRepository modelRepository;
    private static Logger logger = Logger.getLogger(ModelRepositoryController.class);

    @ApiOperation(value="Find a model by a free-text search expression")
    @RequestMapping(value={"/query={expression:.*}"}, method={RequestMethod.GET})
    public List<ModelInfo> searchByExpression(@ApiParam(value="a free-text search expression", required=true) @PathVariable String expression) {
        List modelResources = this.modelRepository.search(expression);
        logger.info((Object)("searchByExpression: [" + expression + "] Rows returned: " + modelResources.size()));
        return modelResources.stream().map(resource -> ModelDtoFactory.createDto((ModelInfo)resource)).collect(Collectors.toList());
    }

    @ApiOperation(value="Returns a model by its full qualified model ID")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public ModelInfo getModelResource(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        logger.info((Object)("getModelResource: [" + modelId.toString() + "]"));
        ModelInfo resource = this.modelRepository.getById(modelId);
        if (resource == null) {
            throw new ModelNotFoundException("Model does not exist", null);
        }
        return ModelDtoFactory.createDto((ModelInfo)resource);
    }

    @ApiOperation(value="Returns the model content")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/content/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public AbstractModel getModelContent(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version) {
        byte[] modelContent = this.createZipWithAllDependencies(new ModelId(name, namespace, version), IModelRepository.ContentType.DSL);
        ModelZipFileExtractor extractor = new ModelZipFileExtractor(modelContent);
        return ModelDtoFactory.createResource((Model)extractor.extract(name));
    }

    @ApiOperation(value="Returns the image of a vorto model")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/image/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public void getModelImage(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="Response", required=true) HttpServletResponse response) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        byte[] modelImage = this.modelRepository.getModelImage(modelId);
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + modelId.getName() + ".png");
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(modelImage), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }

    @ApiOperation(value="Adds an image for a vorto model", hidden=true)
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/image"}, method={RequestMethod.POST})
    public void uploadModelImage(@ApiParam(value="The image to upload", required=true) @RequestParam(value="file") MultipartFile file, @ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @RequestParam String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @RequestParam String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @RequestParam String version) {
        logger.info((Object)("uploadImage: [" + file.getOriginalFilename() + "]"));
        try {
            this.modelRepository.addModelImage(new ModelId(name, namespace, version), file.getBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiOperation(value="Downloads the model content in a specific output format")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/file/{namespace}/{name}/{version:.+}"}, method={RequestMethod.GET})
    public void downloadModelById(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="Choose output file format, e.g. DSL", required=true) @RequestParam(value="output", required=false) IModelRepository.ContentType outputType, @ApiParam(value="Set true if dependencies shall be included", required=false) @RequestParam(value="includeDependencies", required=false) boolean includeDependencies, HttpServletResponse response) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        logger.info((Object)("downloadModelById: [" + modelId.toString() + "]"));
        IModelRepository.ContentType contentType = outputType;
        if (includeDependencies) {
            byte[] zipContent = this.createZipWithAllDependencies(modelId, contentType);
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + modelId.getNamespace() + "_" + modelId.getName() + "_" + modelId.getVersion() + ".zip");
            response.setContentType(APPLICATION_OCTET_STREAM);
            try {
                IOUtils.copy((InputStream)new ByteArrayInputStream(zipContent), (OutputStream)response.getOutputStream());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying file.", e);
            }
        } else {
            this.createSingleModelContent(modelId, contentType, response);
        }
    }

    private byte[] createZipWithAllDependencies(ModelId modelId, IModelRepository.ContentType contentType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        try {
            this.addModelToZip(zos, modelId, contentType);
            zos.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void createSingleModelContent(ModelId modelId, IModelRepository.ContentType contentType, HttpServletResponse response) {
        byte[] modelContent = this.modelRepository.getModelContent(modelId, contentType).getContent();
        if (modelContent != null && modelContent.length > 0) {
            ModelInfo modelResource = this.modelRepository.getById(modelId);
            response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + this.getFileName(modelResource, contentType));
            response.setContentType(APPLICATION_OCTET_STREAM);
            try {
                IOUtils.copy((InputStream)new ByteArrayInputStream(modelContent), (OutputStream)response.getOutputStream());
                response.flushBuffer();
            }
            catch (IOException e) {
                throw new RuntimeException("Error copying file.", e);
            }
        } else {
            throw new RuntimeException("File not found.");
        }
    }

    private void addModelToZip(ZipOutputStream zipOutputStream, ModelId modelId, IModelRepository.ContentType contentType) throws Exception {
        byte[] modelContent = this.modelRepository.getModelContent(modelId, contentType).getContent();
        ModelInfo modelResource = this.modelRepository.getById(modelId);
        try {
            ZipEntry zipEntry = new ZipEntry(this.getFileName(modelResource, contentType));
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(modelContent);
            zipOutputStream.closeEntry();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ModelId reference : modelResource.getReferences()) {
            this.addModelToZip(zipOutputStream, reference, contentType);
        }
    }

    private String getFileName(ModelInfo modelResource, IModelRepository.ContentType contentType) {
        if (contentType == IModelRepository.ContentType.XMI) {
            return modelResource.getId().getName() + XMI;
        }
        return modelResource.getId().getName() + modelResource.getType().getExtension();
    }

    @ApiOperation(value="Getting all mapping resources")
    @RequestMapping(value={"/mapping/zip/{namespace}/{name}/{version:.+}/{targetPlatform}"}, method={RequestMethod.GET})
    public void getMappingResources(@ApiParam(value="The namespace of vorto model, e.g. com.mycompany", required=true) @PathVariable String namespace, @ApiParam(value="The name of vorto model, e.g. NewInfomodel", required=true) @PathVariable String name, @ApiParam(value="The version of vorto model, e.g. 1.0.0", required=true) @PathVariable String version, @ApiParam(value="The name of target platform, e.g. lwm2m", required=true) @PathVariable String targetPlatform, HttpServletResponse response) {
        Objects.requireNonNull(namespace, "namespace must not be null");
        Objects.requireNonNull(name, "name must not be null");
        Objects.requireNonNull(version, "version must not be null");
        ModelId modelId = new ModelId(name, namespace, version);
        List mappingResources = this.modelRepository.getMappingModelsForTargetPlatform(modelId, targetPlatform);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        IModelRepository.ContentType contentType = IModelRepository.ContentType.DSL;
        try {
            for (ModelInfo mappingResource : mappingResources) {
                this.addModelToZip(zos, mappingResource.getId(), contentType);
            }
            zos.close();
            baos.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        response.setHeader(CONTENT_DISPOSITION, ATTACHMENT_FILENAME + modelId.getNamespace() + "_" + modelId.getName() + "_" + modelId.getVersion() + ".zip");
        response.setContentType(APPLICATION_OCTET_STREAM);
        try {
            IOUtils.copy((InputStream)new ByteArrayInputStream(baos.toByteArray()), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }
}

