/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.resolver;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.resolver.ResolveQuery;
import org.eclipse.vorto.repository.model.IModelContent;
import org.eclipse.vorto.repository.service.IModelIdResolver;
import org.eclipse.vorto.repository.service.IModelRepository;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractResolver
implements IModelIdResolver {
    @Autowired
    protected IModelRepository repository;

    public ModelId resolve(ResolveQuery query) {
        List mappings = this.repository.search(ModelType.Mapping.name());
        Optional<ModelId> foundId = mappings.stream().filter(resource -> this.matchesServiceKey(resource, query.getTargetPlatformKey())).map(r -> this.doResolve(r, query)).filter(modelId -> Objects.nonNull(modelId)).findFirst();
        return foundId.isPresent() ? foundId.get() : null;
    }

    private boolean matchesServiceKey(ModelInfo resource, String targetPlatformKey) {
        IModelContent content = this.repository.getModelContent(resource.getId(), IModelRepository.ContentType.DSL);
        return ((MappingModel)content.getModel()).getTargetPlatform().equals(targetPlatformKey);
    }

    protected abstract ModelId doResolve(ModelInfo var1, ResolveQuery var2);

    public IModelRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IModelRepository repository) {
        this.repository = repository;
    }
}

