/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.workflow.impl.validators;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.workflow.InvalidInputException;
import org.eclipse.vorto.repository.workflow.model.IAction;
import org.eclipse.vorto.repository.workflow.model.IWorkflowValidator;

public class CheckStatesOfDependenciesValidator
implements IWorkflowValidator {
    private IModelRepository modelRepository;
    private Set<String> states = new HashSet<String>();

    public CheckStatesOfDependenciesValidator(IModelRepository modelRepository, String state, String ... states) {
        this.modelRepository = modelRepository;
        this.states.add(state);
        this.states.addAll(Arrays.asList(states));
    }

    @Override
    public void validate(ModelInfo model, IAction currentAction) throws InvalidInputException {
        for (ModelId referencedModelId : model.getReferences()) {
            ModelInfo referencedModel = this.modelRepository.getById(referencedModelId);
            if (referencedModel == null) {
                throw new InvalidInputException("Referenced Model with ID '" + referencedModelId + "' does not exist in repository.", model);
            }
            String referencedModelState = referencedModel.getState();
            if (this.states.contains(referencedModelState)) continue;
            throw new InvalidInputException("Referenced Model with ID '" + referencedModelId + "' is not in state(s) [" + this.states + "]", model);
        }
    }
}

