/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.workflow.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.workflow.impl.DefaultAction;
import org.eclipse.vorto.repository.workflow.impl.DefaultState;
import org.eclipse.vorto.repository.workflow.impl.conditions.IsAdminCondition;
import org.eclipse.vorto.repository.workflow.impl.conditions.IsOwnerCondition;
import org.eclipse.vorto.repository.workflow.impl.conditions.OrCondition;
import org.eclipse.vorto.repository.workflow.impl.validators.CheckStatesOfDependenciesValidator;
import org.eclipse.vorto.repository.workflow.model.IAction;
import org.eclipse.vorto.repository.workflow.model.IState;
import org.eclipse.vorto.repository.workflow.model.IWorkflowCondition;
import org.eclipse.vorto.repository.workflow.model.IWorkflowModel;

public class SimpleWorkflowModel
implements IWorkflowModel {
    private String name;
    private String description;
    private static DefaultAction ACTION_INITAL = new DefaultAction("start");
    public static DefaultAction ACTION_RELEASE = new DefaultAction("Release", "Releasing a model will trigger an internal review process, done by the Vorto Team. Once approved, your model will be released and is publicly visible.");
    public static DefaultAction ACTION_APPROVE = new DefaultAction("Approve", "You agree to the model and its content and confirm the model release.");
    public static DefaultAction ACTION_REJECT = new DefaultAction("Reject", "You do not agree to the model and its content. Please use comments to give feedback to author.");
    public static DefaultAction ACTION_WITHDRAW = new DefaultAction("Withdraw", "When you withdraw, the review process is stopped and your model returns to Draft state where you can make changes.");
    public static DefaultAction ACTION_DEPRECATE = new DefaultAction("Deprecate", "Marks the model as deprecated but remains publicly visible.");
    public static DefaultState STATE_DRAFT = new DefaultState("Draft", "A draft model is only viewable and editable by the model owner.");
    public static DefaultState STATE_IN_REVIEW = new DefaultState("InReview", "Being reviewed by the Vorto Team.");
    public static DefaultState STATE_RELEASED = new DefaultState("Released", "A released model has been successfully reviewed and can viewed by everybody.");
    public static DefaultState STATE_DEPRECATED = new DefaultState("Deprecated", "A deprecated model indicates that the model is obsolete and shall not be used any more.");
    private static final IWorkflowCondition ONLY_OWNER = new IsOwnerCondition();
    private static final List<IState> ALL_STATES = Arrays.asList(STATE_DRAFT, STATE_IN_REVIEW, STATE_RELEASED, STATE_DEPRECATED);

    public SimpleWorkflowModel(IUserRepository userRepository, IModelRepository repository) {
        IsAdminCondition isAdminCondition = new IsAdminCondition(userRepository);
        ACTION_INITAL.setTo(STATE_DRAFT);
        ACTION_RELEASE.setTo(STATE_IN_REVIEW);
        ACTION_RELEASE.setConditions(new OrCondition(ONLY_OWNER, isAdminCondition));
        ACTION_RELEASE.setValidators(new CheckStatesOfDependenciesValidator(repository, STATE_IN_REVIEW.getName(), STATE_RELEASED.getName(), STATE_DEPRECATED.getName()));
        ACTION_APPROVE.setTo(STATE_RELEASED);
        ACTION_APPROVE.setConditions(isAdminCondition);
        ACTION_APPROVE.setValidators(new CheckStatesOfDependenciesValidator(repository, STATE_RELEASED.getName(), STATE_DEPRECATED.getName()));
        ACTION_REJECT.setTo(STATE_DRAFT);
        ACTION_REJECT.setConditions(isAdminCondition);
        ACTION_WITHDRAW.setTo(STATE_DRAFT);
        ACTION_WITHDRAW.setConditions(ONLY_OWNER);
        ACTION_DEPRECATE.setTo(STATE_DEPRECATED);
        ACTION_DEPRECATE.setConditions(isAdminCondition);
        STATE_DRAFT.setActions(ACTION_RELEASE);
        STATE_IN_REVIEW.setActions(ACTION_APPROVE, ACTION_REJECT, ACTION_WITHDRAW);
        STATE_RELEASED.setActions(ACTION_DEPRECATE);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IAction getInitialAction() {
        return ACTION_INITAL;
    }

    @Override
    public Optional<IState> getState(String name) {
        return ALL_STATES.stream().filter(state -> state.getName().equals(name)).findFirst();
    }
}

