/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.importer;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.importer.FileUpload;
import org.eclipse.vorto.repository.importer.IModelImportService;
import org.eclipse.vorto.repository.importer.IModelImporter;
import org.eclipse.vorto.repository.importer.UploadModelResult;
import org.eclipse.vorto.repository.web.core.exceptions.UploadTooLargeException;
import org.eclipse.vorto.repository.web.importer.dto.ImporterInfo;
import org.eclipse.vorto.repository.web.importer.dto.UploadModelResponse;
import org.eclipse.vorto.repository.workflow.IWorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/rest/importers"})
public class ImportController {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final String UPLOAD_VALID = "%s is valid and ready for import.";
    private final String UPLOAD_FAIL = "%s has errors. Cannot import.";
    private final String UPLOAD_WARNING = "Warning! You are about to overwrite an existing model!";
    @Autowired
    private IModelImportService importerService;
    @Value(value="${repo.config.maxModelSize}")
    private long maxModelSize;
    @Autowired
    private IWorkflowService workflowService;

    @RequestMapping(method={RequestMethod.POST})
    public ResponseEntity<UploadModelResponse> uploadModel(@ApiParam(value="The vorto model file to upload", required=true) @RequestParam(value="file") MultipartFile file, @RequestParam(value="key") String key) {
        if (file.getSize() > this.maxModelSize) {
            throw new UploadTooLargeException("model", this.maxModelSize);
        }
        this.LOGGER.info("uploadModel: [" + file.getOriginalFilename() + "]");
        try {
            IModelImporter importer = this.importerService.getImporterByKey(key).get();
            UploadModelResult result = importer.upload(FileUpload.create(file.getOriginalFilename(), file.getBytes()), this.getUserContext());
            if (!result.isValid()) {
                return this.validResponse(new UploadModelResponse(String.format("%s has errors. Cannot import.", file.getOriginalFilename()), result));
            }
            if (result.hasWarnings()) {
                return this.validResponse(new UploadModelResponse(String.format("Warning! You are about to overwrite an existing model!", file.getOriginalFilename()), result));
            }
            return this.validResponse(new UploadModelResponse(String.format("%s is valid and ready for import.", file.getOriginalFilename()), result));
        }
        catch (IOException e) {
            this.LOGGER.error("Error upload model." + e.getStackTrace());
            UploadModelResponse errorResponse = new UploadModelResponse("Error during upload. Try again. " + e.getMessage(), new UploadModelResult(null, Collections.emptyList()));
            return new ResponseEntity((Object)errorResponse, HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private UserContext getUserContext() {
        return UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
    }

    @RequestMapping(value={"/{handleId:.+}"}, method={RequestMethod.PUT})
    public ResponseEntity<List<ModelInfo>> doImport(@ApiParam(value="The file name of uploaded model", required=true) @PathVariable String handleId, @RequestParam(value="key") String key) {
        this.LOGGER.info("Importing Model with handleID " + handleId);
        try {
            IModelImporter importer = this.importerService.getImporterByKey(key).get();
            List<ModelInfo> importedModels = importer.doImport(handleId, this.getUserContext());
            for (ModelInfo modelInfo : importedModels) {
                this.workflowService.start(modelInfo.getId());
            }
            return new ResponseEntity(importedModels, HttpStatus.OK);
        }
        catch (Exception e) {
            this.LOGGER.error("Error Importing model. " + handleId, (Throwable)e);
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    @ApiOperation(value="Returns a list of supported importers")
    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public List<ImporterInfo> getImporters() {
        ArrayList<ImporterInfo> importers = new ArrayList<ImporterInfo>();
        this.importerService.getImporters().stream().forEach(importer -> importers.add(new ImporterInfo(importer.getKey(), importer.getSupportedFileExtensions(), importer.getShortDescription())));
        return importers;
    }

    private ResponseEntity<UploadModelResponse> validResponse(UploadModelResponse successModelResponse) {
        return new ResponseEntity((Object)successModelResponse, HttpStatus.OK);
    }
}

