/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.core;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.attachment.Attachment;
import org.eclipse.vorto.repository.core.FileContent;
import org.eclipse.vorto.repository.core.ModelAlreadyExistsException;
import org.eclipse.vorto.repository.core.ModelResource;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.core.impl.parser.ModelParserFactory;
import org.eclipse.vorto.repository.core.impl.utils.ModelValidationHelper;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;
import org.eclipse.vorto.repository.importer.ValidationReport;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.eclipse.vorto.repository.web.core.ModelContent;
import org.eclipse.vorto.repository.web.core.templates.ModelTemplate;
import org.eclipse.vorto.repository.workflow.IWorkflowService;
import org.eclipse.vorto.repository.workflow.WorkflowException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="internal.modelRepositoryController")
@RequestMapping(value={"/rest/models"})
public class ModelRepositoryController
extends AbstractRepositoryController {
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IWorkflowService workflowService;
    private static Logger logger = Logger.getLogger(ModelRepositoryController.class);

    @ApiOperation(value="Returns the image of a vorto model")
    @ApiResponses(value={@ApiResponse(code=400, message="Wrong input"), @ApiResponse(code=404, message="Model not found")})
    @RequestMapping(value={"/{modelId:.+}/images"}, method={RequestMethod.GET})
    public void getModelImage(@ApiParam(value="The modelId of vorto model, e.g. com.mycompany.Car:1.0.0", required=true) @PathVariable String modelId, @ApiParam(value="Response", required=true) HttpServletResponse response) {
        Objects.requireNonNull(modelId, "modelId must not be null");
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        List<Attachment> imageAttachments = this.modelRepository.getAttachmentsByTag(modelID, Attachment.TAG_IMAGE);
        if (imageAttachments.isEmpty()) {
            response.setStatus(404);
            return;
        }
        response.setHeader("content-disposition", "attachment; filename = " + modelID.getName() + ".png");
        response.setContentType("application/octet-stream");
        try {
            FileContent imageContent = this.modelRepository.getAttachmentContent(modelID, imageAttachments.get(0).getFilename()).get();
            IOUtils.copy((InputStream)new ByteArrayInputStream(imageContent.getContent()), (OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("Error copying file.", e);
        }
    }

    @RequestMapping(value={"/{modelId:.+}/images"}, method={RequestMethod.POST})
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public void uploadModelImage(@ApiParam(value="The image to upload", required=true) @RequestParam(value="file") MultipartFile file, @ApiParam(value="The model ID of vorto model, e.g. com.mycompany.Car:1.0.0", required=true) @PathVariable String modelId) {
        logger.info((Object)("uploadImage: [" + file.getOriginalFilename() + ", " + file.getSize() + "]"));
        try {
            UserContext user = UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
            this.modelRepository.attachFile(ModelId.fromPrettyFormat((String)modelId), new FileContent(file.getOriginalFilename(), file.getBytes()), user, Attachment.TAG_IMAGE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ApiOperation(value="Saves a model to the repository.")
    @PreAuthorize(value="hasRole('ROLE_USER') or hasRole('ROLE_ADMIN')")
    @RequestMapping(method={RequestMethod.PUT}, value={"/{modelId:.+}"}, produces={"application/json"})
    public ValidationReport saveModel(@ApiParam(value="modelId", required=true) @PathVariable String modelId, @RequestBody ModelContent content) {
        try {
            ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
            UserContext userContext = UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
            ModelResource modelInfo = (ModelResource)ModelParserFactory.getParser("model" + ModelType.valueOf((String)content.getType()).getExtension()).parse(new ByteArrayInputStream(content.getContentDsl().getBytes()));
            if (!modelID.equals((Object)modelInfo.getId())) {
                return ValidationReport.invalid((ModelInfo)modelInfo, "You may not change the model ID (name, namespace, version). For this please create a new model.");
            }
            ModelValidationHelper validationHelper = new ModelValidationHelper(this.modelRepository, this.userRepository);
            ValidationReport validationReport = validationHelper.validate(modelInfo, userContext);
            if (validationReport.isValid()) {
                this.modelRepository.save(modelInfo.getId(), content.getContentDsl().getBytes(), modelInfo.getId().getName() + modelInfo.getType().getExtension(), userContext);
            }
            return validationReport;
        }
        catch (ValidationException validationException) {
            return ValidationReport.invalid(null, validationException.getMessage());
        }
    }

    @ApiOperation(value="Creates a model in the repository with the given model ID and model type.")
    @RequestMapping(method={RequestMethod.POST}, value={"/{modelId:.+}/{modelType}"}, produces={"application/json"})
    public ResponseEntity<ModelInfo> createModel(@ApiParam(value="modelId", required=true) @PathVariable String modelId, @ApiParam(value="modelType", required=true) @PathVariable ModelType modelType) throws WorkflowException {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        if (this.modelRepository.getById(modelID) != null) {
            throw new ModelAlreadyExistsException();
        }
        ModelTemplate template = new ModelTemplate();
        UserContext userContext = UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
        ModelInfo savedModel = this.modelRepository.save(modelID, template.createModelTemplate(modelID, modelType).getBytes(), modelID.getName() + modelType.getExtension(), userContext);
        this.workflowService.start(modelID);
        return new ResponseEntity((Object)savedModel, HttpStatus.CREATED);
    }

    @ApiOperation(value="Creates a new version for the given model in the specified version")
    @RequestMapping(method={RequestMethod.POST}, value={"/{modelId:.+}/versions/{modelVersion:.+}"}, produces={"application/json"})
    public ResponseEntity<ModelInfo> createVersionOfModel(@ApiParam(value="modelId", required=true) @PathVariable String modelId, @ApiParam(value="modelVersion", required=true) @PathVariable String modelVersion) throws WorkflowException, IOException {
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        UserContext userContext = UserContext.user(SecurityContextHolder.getContext().getAuthentication().getName());
        ModelResource resource = this.modelRepository.createVersion(modelID, modelVersion, userContext);
        this.workflowService.start(resource.getId());
        return new ResponseEntity((Object)resource, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{modelId:.+}"}, method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('ROLE_ADMIN') or hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:delete')")
    public void deleteModelResource(@PathVariable String modelId) {
        Objects.requireNonNull(modelId, "modelId must not be null");
        this.modelRepository.removeModel(ModelId.fromPrettyFormat((String)modelId));
    }

    @RequestMapping(value={"/mine/download"}, method={RequestMethod.GET})
    public void getUserModels(Principal user, HttpServletResponse response) {
        List<ModelInfo> userModels = this.modelRepository.search("author:" + UserContext.user(user.getName()).getHashedUsername());
        userModels.addAll(this.modelRepository.search("author:" + UserContext.user(user.getName()).getUsername()));
        logger.info((Object)("Exporting information models for " + user.getName() + " results: " + userModels.size()));
        this.sendAsZipFile(response, user.getName() + "-models.zip", userModels);
    }

    @ApiOperation(value="Getting all mapping resources for the given model")
    @PreAuthorize(value="hasRole('ROLE_USER') or hasRole('ROLE_ADMIN') or hasPermission(T(org.eclipse.vorto.repository.api.ModelId).fromPrettyFormat(#modelId),'model:get')")
    @RequestMapping(value={"/{modelId:.+}/download/mappings/{targetPlatform}"}, method={RequestMethod.GET})
    public void downloadMappingsForPlatform(@ApiParam(value="The model ID of vorto model, e.g. com.mycompany.Car:1.0.0", required=true) @PathVariable String modelId, @ApiParam(value="The name of target platform, e.g. lwm2m", required=true) @PathVariable String targetPlatform, HttpServletResponse response) {
        Objects.requireNonNull(modelId, "model ID must not be null");
        ModelId modelID = ModelId.fromPrettyFormat((String)modelId);
        List<ModelInfo> mappingResources = this.modelRepository.getMappingModelsForTargetPlatform(modelID, targetPlatform);
        String fileName = modelID.getNamespace() + "_" + modelID.getName() + "_" + modelID.getVersion() + ".zip";
        this.sendAsZipFile(response, fileName, mappingResources);
    }
}

