/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.upgrade.impl;

import java.util.List;
import java.util.Optional;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.upgrade.AbstractUpgradeTask;
import org.eclipse.vorto.repository.upgrade.IUpgradeTask;
import org.eclipse.vorto.repository.upgrade.IUpgradeTaskCondition;
import org.eclipse.vorto.repository.upgrade.UpgradeProblem;
import org.eclipse.vorto.repository.workflow.IWorkflowService;
import org.eclipse.vorto.repository.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WorkflowUpgradeTask
extends AbstractUpgradeTask
implements IUpgradeTask {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowUpgradeTask.class);
    @Value(value="${server.upgrade.workflow:false}")
    private boolean shouldUpgrade;
    private IUpgradeTaskCondition upgradeTaskCondition = new IUpgradeTaskCondition(){

        @Override
        public boolean shouldExecuteTask() {
            return WorkflowUpgradeTask.this.shouldUpgrade;
        }
    };
    @Autowired
    private IWorkflowService workflowService;

    public WorkflowUpgradeTask(@Autowired IModelRepository repository, @Autowired IWorkflowService workflowService) {
        super(repository);
        this.workflowService = workflowService;
    }

    @Override
    public void doUpgrade() throws UpgradeProblem {
        List<ModelInfo> modelInfos = this.getModelRepository().search("*");
        for (ModelInfo modelInfo : modelInfos) {
            if (modelInfo.getState() != null && !modelInfo.getState().equals("")) continue;
            logger.info("Upgrading " + modelInfo.toString() + " for workflow state management.");
            try {
                this.workflowService.start(modelInfo.getId());
            }
            catch (WorkflowException e) {
                throw new UpgradeProblem("Upgrade failed because workflow cannot be started ", e);
            }
        }
    }

    @Override
    public Optional<IUpgradeTaskCondition> condition() {
        return Optional.of(this.upgradeTaskCondition);
    }

    @Override
    public String getShortDescription() {
        return "Task for setting model states to be controlled by the workflow management.";
    }

    public IUpgradeTaskCondition getUpgradeTaskCondition() {
        return this.upgradeTaskCondition;
    }

    public void setUpgradeTaskCondition(IUpgradeTaskCondition upgradeTaskCondition) {
        this.upgradeTaskCondition = upgradeTaskCondition;
    }
}

