/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.upgrade.impl;

import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.upgrade.UpgradeProblem;
import org.eclipse.vorto.repository.upgrade.impl.AbstractUserUpgradeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;

@Component
public class ModelAuthorUnhashUpgradeTask
extends AbstractUserUpgradeTask {
    @Autowired
    private IModelRepository modelRepository;
    @Autowired
    private IUserRepository userRepository;
    private static final Logger logger = LoggerFactory.getLogger(ModelAuthorUnhashUpgradeTask.class);

    @Override
    public void doUpgrade(User user, Supplier<Object> upgradeContext) throws UpgradeProblem {
        Optional<String> emailPrefix = this.getEmailPrefix((OAuth2Authentication)upgradeContext.get());
        try {
            if (emailPrefix.isPresent()) {
                this.updateModelsFor(UserContext.user(emailPrefix.get()), user);
            }
            this.updateModelsFor(UserContext.user(user.getUsername()), user);
        }
        catch (Exception e) {
            logger.error("error while updating user " + user.getUsername(), (Throwable)e);
        }
        user.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        this.userRepository.save(user);
        logger.info("Updating user: {} with emailPrefix: {}", (Object)user.getUsername(), emailPrefix);
    }

    private void updateModelsFor(IUserContext userContext, User user) {
        List<ModelInfo> models = this.modelRepository.search("author:" + userContext.getHashedUsername());
        logger.info("Found {} models with author {} to update.", (Object)models.size(), (Object)userContext.getHashedUsername());
        for (ModelInfo model : models) {
            logger.info("Setting the author of " + model.getId().toString() + " to " + user.getUsername());
            model.setAuthor(user.getUsername());
            this.modelRepository.updateMeta(model);
        }
    }

    @Override
    public String getShortDescription() {
        return "Updating models whose authors are hashed username into CIAM subject IDs.";
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void setUserRepository(IUserRepository userRepository) {
        this.userRepository = userRepository;
    }
}

