/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.sso;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.web.filter.GenericFilterBean;

public class AuthorizationTokenFilter
extends GenericFilterBean {
    private final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String BEARER = "Bearer";
    private static final String AUTHORIZATION = "Authorization";
    private UserInfoTokenServices userInfoService;

    public AuthorizationTokenFilter(UserInfoTokenServices userInfoService) {
        this.userInfoService = userInfoService;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional<String> authToken;
        if (SecurityContextHolder.getContext().getAuthentication() == null && (authToken = this.getBearerToken((HttpServletRequest)request)).isPresent()) {
            try {
                OAuth2Authentication authentication = this.userInfoService.loadAuthentication(authToken.get());
                if (authentication != null) {
                    SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
                    chain.doFilter(request, response);
                    SecurityContextHolder.getContext().setAuthentication(null);
                    return;
                }
            }
            catch (InvalidTokenException e) {
                this.LOGGER.warn("Invalid token.", (Throwable)e);
                ((HttpServletResponse)response).sendError(401, e.getMessage());
                return;
            }
            catch (Exception e) {
                this.LOGGER.warn("Server Error.", (Throwable)e);
                ((HttpServletResponse)response).sendError(500, e.getMessage());
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public Optional<String> getBearerToken(HttpServletRequest request) {
        String[] tokenComposite;
        String authToken = request.getHeader(AUTHORIZATION);
        if (!Strings.nullToEmpty((String)authToken).trim().isEmpty() && BEARER.equals((tokenComposite = authToken.split(" "))[0]) && !Strings.nullToEmpty((String)tokenComposite[1]).isEmpty()) {
            return Optional.of(tokenComposite[1]);
        }
        return Optional.empty();
    }
}

