/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.validation;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.core.AttachmentException;
import org.eclipse.vorto.repository.core.FileContent;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AttachmentValidator {
    private static int ONE_KB = 1024;
    @Value(value="#{'${repo.attachment.allowed.extension}'.split(',')}")
    private List<String> allowedExtension;
    @Value(value="${repo.attachment.allowed.fileSize: 2}")
    private int fileSize;

    public void validateAttachment(FileContent file, ModelId modelId) throws AttachmentException {
        this.validateFileLength(file, modelId);
        if (this.getFileSizeInMegaBytes(file.getSize()) > (long)this.fileSize) {
            throw new AttachmentException(modelId, "File size exceeded. Allowed max size: " + this.fileSize + " MB.");
        }
        if (!this.allowedExtension.stream().anyMatch(this.isExtensionAllowed(file.getFileName()))) {
            throw new AttachmentException(modelId, "File type not supported. Supported File types :" + this.allowedExtension);
        }
    }

    private void validateFileLength(FileContent file, ModelId modelId) throws AttachmentException {
        String fileName;
        try {
            fileName = URLDecoder.decode(file.getFileName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AttachmentException(modelId, (Throwable)e);
        }
        if (fileName.length() > 100) {
            throw new AttachmentException(modelId, "Name of File exceeds 100 Characters");
        }
    }

    private long getFileSizeInMegaBytes(long size) {
        return size / (long)(ONE_KB * ONE_KB);
    }

    private Predicate<String> isExtensionAllowed(String fileName) {
        return extension -> FilenameUtils.getExtension((String)fileName).equals(extension.trim());
    }
}

