/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.workflow.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.vorto.repository.workflow.model.IAction;
import org.eclipse.vorto.repository.workflow.model.IState;
import org.eclipse.vorto.repository.workflow.model.IWorkflowCondition;
import org.eclipse.vorto.repository.workflow.model.IWorkflowValidator;

public class DefaultAction
implements IAction {
    private String name;
    private String description;
    private IState to;
    private List<IWorkflowCondition> conditions = new ArrayList<IWorkflowCondition>();
    private List<IWorkflowValidator> validators = new ArrayList<IWorkflowValidator>();

    public DefaultAction(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public DefaultAction(String name) {
        this(name, "");
    }

    public void setTo(IState to) {
        this.to = to;
    }

    public void setConditions(IWorkflowCondition ... conditions) {
        this.conditions = Arrays.asList(conditions);
    }

    public void setValidators(IWorkflowValidator ... validators) {
        this.validators = Arrays.asList(validators);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public IState getTo() {
        return this.to;
    }

    public String toString() {
        return "DefaultAction [name=" + this.name + ", description=" + this.description + ", to=" + this.to + "]";
    }

    @Override
    public List<IWorkflowCondition> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    @Override
    public List<IWorkflowValidator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }
}

