/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.generation;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import org.eclipse.vorto.repository.api.generation.GeneratorInfo;
import org.eclipse.vorto.repository.generation.IGeneratorService;
import org.eclipse.vorto.repository.web.AbstractRepositoryController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@Api(value="/generate", description="Generate code from information models")
@RestController(value="internal.GeneratorController")
@RequestMapping(value={"/rest/generators"})
public class GeneratorController
extends AbstractRepositoryController {
    @Autowired
    private IGeneratorService generatorService;

    @ApiOperation(value="Returns the rank of code generators by usage")
    @RequestMapping(value={"/rankings/{top}"}, method={RequestMethod.GET}, produces={"application/json"})
    public Collection<GeneratorInfo> getMostlyUsedGenerators(@ApiParam(value="The upper limit number of top code generator list", required=true) @PathVariable int top) {
        return this.generatorService.getMostlyUsedGenerators(top);
    }

    @ApiOperation(value="Register a code generator", hidden=true)
    @RequestMapping(value={"/{serviceKey}"}, method={RequestMethod.PUT})
    public void registerGenerator(@ApiParam(value="Service key for a specified platform, e.g. lwm2m", required=true) @PathVariable String serviceKey, @ApiParam(value="The URL links to a specified code generator", required=true) @RequestBody String baseUrl) {
        this.generatorService.registerGenerator(serviceKey, baseUrl);
    }

    @ApiOperation(value="Deregister a code generator", hidden=true)
    @RequestMapping(value={"/{serviceKey}"}, method={RequestMethod.DELETE})
    public boolean deregisterGenerator(@ApiParam(value="Service key for a specified platform, e.g. lwm2m", required=true) @PathVariable String serviceKey) {
        this.generatorService.unregisterGenerator(serviceKey);
        return true;
    }
}

