/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.importer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.impl.validation.CouldNotResolveReferenceException;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;
import org.eclipse.vorto.repository.importer.MessageSeverity;
import org.eclipse.vorto.repository.importer.StatusMessage;

public class ValidationReport {
    public static final StatusMessage ERROR_MODEL_ALREADY_RELEASED = new StatusMessage("The model with this version is already released. Please create a new version.", MessageSeverity.ERROR);
    public static final StatusMessage WARNING_MODEL_ALREADY_EXISTS = new StatusMessage("A model with this version already exists, and will be overwritten upon import.", MessageSeverity.WARNING);
    public static final StatusMessage ERROR_MODEL_ALREADY_EXISTS = new StatusMessage("A model with this version has already been created by another user.", MessageSeverity.ERROR);
    private ModelInfo model = null;
    private boolean valid = false;
    private StatusMessage message = null;
    private Collection<ModelId> unresolvedReferences = new ArrayList<ModelId>();

    public ValidationReport(ModelInfo model, boolean valid, StatusMessage message, Collection<ModelId> missingReferences) {
        this.model = model;
        this.valid = valid;
        this.message = message;
        this.unresolvedReferences.addAll(missingReferences);
    }

    public static ValidationReport invalid(ModelInfo model, String msg) {
        return new ValidationReport(model, false, new StatusMessage(msg, MessageSeverity.ERROR), Collections.emptyList());
    }

    public static ValidationReport invalid(String msg) {
        return new ValidationReport(null, false, new StatusMessage(msg, MessageSeverity.ERROR), Collections.emptyList());
    }

    public static ValidationReport invalid(ModelInfo model, String msg, Collection<ModelId> missingReferences) {
        return new ValidationReport(model, false, new StatusMessage(msg, MessageSeverity.ERROR), missingReferences);
    }

    public static ValidationReport invalid(ModelInfo model, ValidationException exception) {
        if (exception instanceof CouldNotResolveReferenceException) {
            CouldNotResolveReferenceException ex = (CouldNotResolveReferenceException)exception;
            return new ValidationReport(model, false, new StatusMessage(exception.getMessage(), MessageSeverity.ERROR), ex.getMissingReferences());
        }
        return new ValidationReport(model, false, new StatusMessage(exception.getMessage(), MessageSeverity.ERROR), Collections.emptyList());
    }

    public static ValidationReport valid(ModelInfo model) {
        return new ValidationReport(model, true, new StatusMessage("The model is valid.", MessageSeverity.INFO), Collections.emptyList());
    }

    protected ValidationReport() {
    }

    public ModelInfo getModel() {
        return this.model;
    }

    public void setModel(ModelInfo model) {
        this.model = model;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public StatusMessage getMessage() {
        return this.message;
    }

    public void setMessage(StatusMessage message) {
        this.message = message;
    }

    public Collection<ModelId> getUnresolvedReferences() {
        return this.unresolvedReferences;
    }

    public void setUnresolvedReferences(Collection<ModelId> unresolvedReferences) {
        this.unresolvedReferences = unresolvedReferences;
    }
}

