/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.resolver;

import java.util.Optional;
import org.eclipse.vorto.core.api.model.mapping.Attribute;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.mapping.MappingRule;
import org.eclipse.vorto.core.api.model.mapping.StereoTypeTarget;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.ModelFileContent;
import org.eclipse.vorto.repository.core.impl.resolver.AbstractResolver;
import org.eclipse.vorto.repository.web.core.dto.ResolveQuery;
import org.springframework.stereotype.Service;

@Service
public class DefaultResolver
extends AbstractResolver {
    @Override
    protected ModelId doResolve(ModelInfo mappingModelResource, ResolveQuery query) {
        Optional<Attribute> objectIdAttribute;
        ModelFileContent content = this.repository.getModelContent(mappingModelResource.getId());
        MappingModel mappingModel = (MappingModel)content.getModel();
        Optional<MappingRule> objectRule = mappingModel.getRules().stream().filter(rule -> rule.getTarget() instanceof StereoTypeTarget && ((StereoTypeTarget)rule.getTarget()).getName().equals(query.getStereoType())).findFirst();
        if (objectRule.isPresent() && (objectIdAttribute = ((StereoTypeTarget)objectRule.get().getTarget()).getAttributes().stream().filter(attribute -> attribute.getName().equals(query.getAttributeId())).findFirst()).isPresent() && objectIdAttribute.get().getValue().equals(query.getAttributeValue())) {
            return ModelId.fromReference((String)((ModelReference)mappingModel.getReferences().get(0)).getImportedNamespace(), (String)((ModelReference)mappingModel.getReferences().get(0)).getVersion());
        }
        return null;
    }
}

