/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.workflow.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.vorto.repository.workflow.model.IAction;
import org.eclipse.vorto.repository.workflow.model.IState;

public class DefaultState
implements IState {
    private String name;
    private String description;
    private List<IAction> actions = new ArrayList<IAction>();

    public DefaultState(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public DefaultState(String name) {
        this(name, "");
    }

    public void setActions(IAction ... actions) {
        this.actions = Arrays.asList(actions);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<IAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    @Override
    public Optional<IAction> getAction(String name) {
        return this.actions.stream().filter(action -> action.getName().equalsIgnoreCase(name)).findFirst();
    }

    public String toString() {
        return "DefaultState [name=" + this.name + ", description=" + this.description + ", actions=" + this.actions + "]";
    }
}

