/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.security;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.impl.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.stereotype.Component;

@Component
public class UserAuthoritiesExtractor
implements AuthoritiesExtractor {
    @Autowired
    public IUserAccountService userService;

    public List<GrantedAuthority> extractAuthorities(Map<String, Object> map) {
        String username = (String)map.get("login");
        User user = this.userService.getUser(username);
        if (user == null) {
            return Collections.emptyList();
        }
        return AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_" + user.getRole().name()});
    }
}

