/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.security;

import java.io.Serializable;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.workflow.impl.SimpleWorkflowModel;
import org.springframework.security.access.PermissionEvaluator;
import org.springframework.security.core.Authentication;

public class HasPermissionEvaluator
implements PermissionEvaluator {
    private IModelRepository repository;

    public HasPermissionEvaluator(IModelRepository repository) {
        this.repository = repository;
    }

    public HasPermissionEvaluator() {
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        String callerId = authentication.getName();
        if (targetDomainObject instanceof ModelId) {
            ModelInfo modelInfo = this.repository.getById((ModelId)targetDomainObject);
            if (modelInfo != null) {
                if ("model:delete".equalsIgnoreCase((String)permission)) {
                    return modelInfo.getAuthor().equalsIgnoreCase(UserContext.user(callerId).getHashedUsername()) || modelInfo.getAuthor().equalsIgnoreCase(UserContext.user(callerId).getUsername());
                }
                if ("model:get".equalsIgnoreCase((String)permission)) {
                    UserContext user = UserContext.user(authentication.getName());
                    return modelInfo.getState().equals(SimpleWorkflowModel.STATE_RELEASED.getName()) || modelInfo.getState().equals(SimpleWorkflowModel.STATE_DEPRECATED.getName()) || modelInfo.getAuthor().equals(user.getHashedUsername()) || modelInfo.getAuthor().equals(user.getUsername());
                }
                if ("model:owner".equalsIgnoreCase((String)permission)) {
                    UserContext user = UserContext.user(authentication.getName());
                    return modelInfo.getAuthor().equals(user.getHashedUsername()) || modelInfo.getAuthor().equals(user.getUsername());
                }
            }
        } else if (targetDomainObject instanceof String) {
            return callerId.equalsIgnoreCase((String)targetDomainObject);
        }
        return false;
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        return false;
    }
}

