/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.core;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.core.IModelIdResolver;
import org.eclipse.vorto.repository.core.impl.resolver.UnknownModelIdResolverException;
import org.eclipse.vorto.repository.web.core.ModelDtoFactory;
import org.eclipse.vorto.repository.web.core.dto.ResolveQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/models/resolvers"})
@Api(value="/resolve", description="Resolve information models by mapped platform attributes")
public class ModelResolveController {
    @Autowired
    private IModelIdResolver resolver;

    @ApiOperation(value="Resolves a vorto model by a platform specific object identifier, defined in model mappings")
    @ApiResponses(value={@ApiResponse(code=404, message="Resolver not found for specified generator service key")})
    @RequestMapping(value={"/{serviceKey}/{stereoType}/{attributeId}/{attributeValue}"}, method={RequestMethod.GET})
    public ModelId resolve(@ApiParam(value="Generator service key, e.g. LWM2M", required=true) @PathVariable(value="serviceKey") String serviceKey, @ApiParam(value="Platform specific stereotype name defined in mappings", required=true) @PathVariable(value="stereoType") String stereoType, @ApiParam(value="Platform specific attributeId defined in mappings", required=true) @PathVariable(value="attributeId") String attributeId, @ApiParam(value="Platform specific attributeValue defined in mappings", required=true) @PathVariable(value="attributeValue") String attributeValue) throws Exception {
        ModelId resolvedId = this.resolver.resolve(new ResolveQuery(serviceKey, attributeId, attributeValue, stereoType));
        if (resolvedId != null) {
            return ModelDtoFactory.createDto(resolvedId);
        }
        throw new ModelNotFoundException("No Model found");
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Model not found.")
    @ExceptionHandler(value={ModelNotFoundException.class})
    public void NotFound(ModelNotFoundException ex) {
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND, reason="Unknown resolver.")
    @ExceptionHandler(value={UnknownModelIdResolverException.class})
    public void UnknownModelIdResolver(UnknownModelIdResolverException ex) {
    }
}

