/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.WebUtils;

public class AngularCsrfHeaderFilter
extends OncePerRequestFilter {
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        CsrfToken csrf = this.getCsrfToken(request);
        if (csrf != null) {
            Cookie cookie = this.getWebCookies(request);
            String token = csrf.getToken();
            if (cookie == null || token != null && !token.equals(cookie.getValue())) {
                this.addNewCookieToReponse(response, token);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void addNewCookieToReponse(HttpServletResponse response, String token) {
        Cookie cookie = new Cookie("XSRF-TOKEN", token);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    private Cookie getWebCookies(HttpServletRequest request) {
        return WebUtils.getCookie((HttpServletRequest)request, (String)"XSRF-TOKEN");
    }

    private CsrfToken getCsrfToken(HttpServletRequest request) {
        return (CsrfToken)request.getAttribute(CsrfToken.class.getName());
    }
}

