/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.upgrade.impl;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.comment.Comment;
import org.eclipse.vorto.repository.comment.ICommentService;
import org.eclipse.vorto.repository.core.IUserContext;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.eclipse.vorto.repository.upgrade.UpgradeProblem;
import org.eclipse.vorto.repository.upgrade.impl.AbstractUserUpgradeTask;
import org.eclipse.vorto.repository.upgrade.impl.ModelAuthorUnhashUpgradeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.stereotype.Component;

@Component
public class CommentAuthorUnhashUpgradeTask
extends AbstractUserUpgradeTask {
    @Autowired
    private ICommentService commentService;
    private static final Logger logger = LoggerFactory.getLogger(ModelAuthorUnhashUpgradeTask.class);

    @Override
    public void doUpgrade(User user, Supplier<Object> upgradeContext) throws UpgradeProblem {
        Optional<String> emailPrefix = this.getEmailPrefix((OAuth2Authentication)upgradeContext.get());
        try {
            if (emailPrefix.isPresent()) {
                this.updateModelsFor(UserContext.user(emailPrefix.get()), user);
            }
            this.updateModelsFor(UserContext.user(user.getUsername()), user);
        }
        catch (Exception e) {
            logger.error("error while updating user " + user.getUsername(), (Throwable)e);
        }
        logger.info("Finished updating comments for '{}' with emailPrefix '{}'", (Object)user.getUsername(), emailPrefix);
    }

    private void updateModelsFor(IUserContext userContext, User user) {
        List<Comment> comments = this.commentService.getCommentsByAuthor(userContext.getHashedUsername());
        for (Comment comment : comments) {
            comment.setAuthor(user.getUsername());
            this.commentService.saveComment(comment);
            logger.info("Setting Comment '{}' to author '{}'", (Object)comment.getContent(), (Object)user.getUsername());
        }
    }

    @Override
    public String getShortDescription() {
        return "Unhash the author of Comments";
    }

    public void setCommentService(ICommentService commentService) {
        this.commentService = commentService;
    }
}

