/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.upgrade.impl;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.upgrade.IUpgradeTaskCondition;
import org.eclipse.vorto.repository.upgrade.IUserUpgradeTask;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;

abstract class AbstractUserUpgradeTask
implements IUserUpgradeTask {
    AbstractUserUpgradeTask() {
    }

    protected Optional<String> getEmailPrefix(OAuth2Authentication oauth2User) {
        UsernamePasswordAuthenticationToken userAuth = (UsernamePasswordAuthenticationToken)oauth2User.getUserAuthentication();
        Map userDetailsMap = (Map)userAuth.getDetails();
        String email = (String)userDetailsMap.get("email");
        if (email == null) {
            return Optional.empty();
        }
        return Optional.of(email.split("@")[0]);
    }

    @Override
    public Optional<IUpgradeTaskCondition> condition(User user, Supplier<Object> upgradeContext) {
        return Optional.of(() -> upgradeContext.get() instanceof OAuth2Authentication);
    }
}

