/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.importer;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vorto.repository.importer.MessageSeverity;
import org.eclipse.vorto.repository.importer.ValidationReport;

public class UploadModelResult {
    private String handleId = null;
    private boolean isValid = false;
    private boolean hasWarnings = false;
    private List<ValidationReport> reports = new ArrayList<ValidationReport>();

    public UploadModelResult(String handleId, List<ValidationReport> reports) {
        this.handleId = handleId;
        this.reports.addAll(reports);
        this.isValid = reports.stream().filter(report -> !report.isValid()).count() == 0L;
        this.hasWarnings = reports.stream().filter(report -> report.getMessage().getSeverity() == MessageSeverity.WARNING).count() > 0L;
    }

    protected UploadModelResult() {
    }

    public String getHandleId() {
        return this.handleId;
    }

    public List<ValidationReport> getReport() {
        return this.reports;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public List<ValidationReport> getReports() {
        return this.reports;
    }

    public void setReports(List<ValidationReport> reports) {
        this.reports = reports;
    }

    public void setHandleId(String handleId) {
        this.handleId = handleId;
    }

    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    public void setHasWarnings(boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.handleId == null ? 0 : this.handleId.hashCode());
        result = 31 * result + (this.hasWarnings ? 1231 : 1237);
        result = 31 * result + (this.isValid ? 1231 : 1237);
        result = 31 * result + (this.reports == null ? 0 : this.reports.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UploadModelResult other = (UploadModelResult)obj;
        if (this.handleId == null ? other.handleId != null : !this.handleId.equals(other.handleId)) {
            return false;
        }
        if (this.hasWarnings != other.hasWarnings) {
            return false;
        }
        if (this.isValid != other.isValid) {
            return false;
        }
        return !(this.reports == null ? other.reports != null : !this.reports.equals(other.reports));
    }

    public String toString() {
        return "UploadModelResult [handleId=" + this.handleId + ", isValid=" + this.isValid + ", hasWarnings=" + this.hasWarnings + ", reports=" + this.reports + "]";
    }
}

