/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.InvocationContext;
import org.eclipse.vorto.repository.core.impl.validation.CouldNotResolveReferenceException;
import org.eclipse.vorto.repository.core.impl.validation.ModelReferencesValidation;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;

public class BulkModelReferencesValidation
extends ModelReferencesValidation {
    private List<ModelId> zipModelIds;

    public BulkModelReferencesValidation(IModelRepository modelRepository, Set<ModelInfo> modelResources) {
        super(modelRepository);
        this.zipModelIds = modelResources.stream().map(new Function<ModelInfo, ModelId>(){

            @Override
            public ModelId apply(ModelInfo resource) {
                return resource.getId();
            }
        }).collect(Collectors.toList());
    }

    @Override
    public void validate(ModelInfo modelResource, InvocationContext context) throws ValidationException {
        this.validateInRepository(modelResource, context);
        this.validateInZipFiles(modelResource);
    }

    private List<ModelId> validateInRepository(ModelInfo modelResource, InvocationContext context) {
        ArrayList<ModelId> missingReferences = new ArrayList<ModelId>();
        try {
            super.validate(modelResource, context);
        }
        catch (CouldNotResolveReferenceException e) {
            return e.getMissingReferences();
        }
        return missingReferences;
    }

    private boolean isNotInRepository(ModelId modelId) {
        return this.getModelRepository().getById(modelId) == null;
    }

    private void validateInZipFiles(ModelInfo modelResource) {
        List references = modelResource.getReferences();
        ArrayList<ModelId> missingReferences = new ArrayList<ModelId>();
        for (ModelId modelId : references) {
            if (this.zipModelIds.contains(modelId) || !this.isNotInRepository(modelId)) continue;
            missingReferences.add(modelId);
        }
        if (missingReferences.size() > 0) {
            throw new CouldNotResolveReferenceException(modelResource, missingReferences);
        }
    }
}

