/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.core.impl.validation.CouldNotResolveReferenceException;
import org.eclipse.vorto.repository.core.impl.validation.ValidationException;
import org.eclipse.vorto.repository.importer.ValidationReport;

public class ValidationReportFactory {
    public static ValidationReport create(ValidationException ... validationExceptions) {
        Objects.requireNonNull(validationExceptions);
        if (validationExceptions.length <= 0) {
            throw new IllegalArgumentException("There ought to be more than 1 validation exception for this function.");
        }
        StringBuffer errorMessage = new StringBuffer();
        List<ModelId> missingReferences = Collections.emptyList();
        for (int i = 0; i < validationExceptions.length; ++i) {
            if (validationExceptions[i] instanceof CouldNotResolveReferenceException) {
                missingReferences = ((CouldNotResolveReferenceException)validationExceptions[i]).getMissingReferences();
            }
            if (errorMessage.length() != 0) {
                errorMessage.append("\n");
            }
            errorMessage.append(i + 1);
            errorMessage.append(") ");
            errorMessage.append(validationExceptions[i].getMessage());
        }
        return ValidationReport.invalid(validationExceptions[0].getModelResource(), errorMessage.toString(), missingReferences);
    }
}

