/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.core.impl;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.vorto.repository.core.IUserContext;

public class UserContext
implements IUserContext {
    private String username;

    public static UserContext user(String username) {
        return new UserContext(username);
    }

    private UserContext() {
    }

    private UserContext(String username) {
        this.username = username;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getHashedUsername() {
        return this.getHash(this.username);
    }

    private String getHash(String username) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return this.bytesToHex(digest.digest(username.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Exception in getting has of username: " + username, e);
        }
    }

    private String bytesToHex(byte[] hash) {
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < hash.length; ++i) {
            String hex = Integer.toHexString(0xFF & hash[i]);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    @Override
    public boolean isAnonymous() {
        return this.username.equalsIgnoreCase("anonymous");
    }
}

