/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.comment;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;
import org.eclipse.vorto.repository.api.ModelId;

@Entity
public class Comment {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @NotNull
    private String modelId;
    @NotNull
    private String author;
    private String firstname;
    private String lastname;
    @NotNull
    private String content;
    private String createdOn;

    public Comment() {
    }

    public Comment(ModelId modelId, String author, String content) {
        this.modelId = modelId.getPrettyFormat();
        this.author = author;
        this.content = content;
        this.createdOn = "";
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getDate() {
        return this.createdOn;
    }

    public void setDate(Date createdOn) {
        String formattedDate;
        String strDateFormat = "hh:mm a dd-MM-yyyy";
        SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
        this.createdOn = formattedDate = dateFormat.format(createdOn);
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }
}

