/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.account.impl;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.eclipse.vorto.repository.account.IUserAccountService;
import org.eclipse.vorto.repository.account.Role;
import org.eclipse.vorto.repository.account.impl.IUserRepository;
import org.eclipse.vorto.repository.account.impl.User;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.core.IModelRepository;
import org.eclipse.vorto.repository.core.impl.UserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DefaultUserAccountService
implements IUserAccountService {
    private static final String USER_ANONYMOUS = "anonymous";
    @Value(value="${server.admin:#{null}}")
    private String admins;
    @Autowired
    private IUserRepository userRepository;
    @Autowired
    private IModelRepository modelRepository;

    @Override
    public User create(String username) {
        User user = new User();
        user.setUsername(username);
        user.setDateCreated(new Timestamp(System.currentTimeMillis()));
        user.setLastUpdated(new Timestamp(System.currentTimeMillis()));
        user.setAckOfTermsAndCondTimestamp(new Timestamp(System.currentTimeMillis()));
        user.setRole(this.toRole(username));
        user = (User)this.userRepository.save(user);
        return user;
    }

    private Role toRole(String username) {
        if (this.admins != null && Arrays.asList(this.admins.split(";")).contains(username)) {
            return Role.ADMIN;
        }
        return Role.USER;
    }

    @Override
    public void delete(String userId) {
        User userToDelete = this.userRepository.findByUsername(userId);
        if (userToDelete != null) {
            this.makeModelsAnonymous(UserContext.user(userToDelete.getUsername()).getHashedUsername());
            this.makeModelsAnonymous(userToDelete.getUsername());
            this.userRepository.delete(userToDelete);
        }
    }

    private void makeModelsAnonymous(String username) {
        List<ModelInfo> userModels = this.modelRepository.search("author:" + username);
        for (ModelInfo model : userModels) {
            model.setAuthor(USER_ANONYMOUS);
            this.modelRepository.updateMeta(model);
        }
    }

    public IUserRepository getUserRepository() {
        return this.userRepository;
    }

    public void setUserRepository(IUserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    @Override
    public boolean exists(String userId) {
        return this.userRepository.findByUsername(userId) != null;
    }

    @Override
    public String getAnonymousUserId() {
        return USER_ANONYMOUS;
    }

    @Override
    public User getUser(String username) {
        return this.userRepository.findByUsername(username);
    }

    @Override
    public void saveUser(User user) {
        this.userRepository.save(user);
    }
}

