/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web.comment;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.model.Comment;
import org.eclipse.vorto.repository.service.ICommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Api(value="Comment Controller", description="REST API to manage Comments")
@RestController
@RequestMapping(value={"/rest"})
public class CommentController {
    @Autowired
    private ICommentService commentService;

    @ApiOperation(value="Returns comments for a specific Model Resource")
    @ApiResponses(value={@ApiResponse(code=404, message="Not found"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(method={RequestMethod.GET}, value={"/comments/model/{namespace}/{name}/{version:.+}"}, produces={"application/json"})
    public List<Comment> getCommentsforModelId(@ApiParam(value="namespace", required=true) @PathVariable String namespace, @ApiParam(value="name", required=true) @PathVariable String name, @ApiParam(value="version", required=true) @PathVariable String version) {
        ModelId modelId = new ModelId(name, namespace, version);
        List comments = this.commentService.getCommentsforModelId(modelId);
        return comments;
    }

    @ApiOperation(value="Returns comments for a specific Model Resource")
    @ApiResponses(value={@ApiResponse(code=404, message="Not found"), @ApiResponse(code=200, message="OK")})
    @RequestMapping(method={RequestMethod.POST}, value={"/comments"}, consumes={"application/json"})
    public void addCommentforModelResource(@RequestBody @Valid Comment comment) throws Exception {
        this.commentService.createComment(comment);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(code=HttpStatus.INTERNAL_SERVER_ERROR)
    public void exceptionHandlerException() {
    }

    @ExceptionHandler(value={UsernameNotFoundException.class})
    @ResponseStatus(code=HttpStatus.INTERNAL_SERVER_ERROR)
    public void exceptionHandlerUsernameNotFoundException() {
    }
}

