/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.web;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.vorto.core.api.model.datatype.BooleanPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteral;
import org.eclipse.vorto.core.api.model.datatype.EnumLiteralPropertyAttribute;
import org.eclipse.vorto.core.api.model.datatype.ObjectPropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitivePropertyType;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.datatype.Property;
import org.eclipse.vorto.core.api.model.datatype.PropertyAttribute;
import org.eclipse.vorto.core.api.model.functionblock.Event;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockModel;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.RefParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnObjectType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.vorto.core.api.model.mapping.MappingModel;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.core.api.model.model.ModelReference;
import org.eclipse.vorto.repository.api.AbstractModel;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.content.BooleanAttributeProperty;
import org.eclipse.vorto.repository.api.content.BooleanAttributePropertyType;
import org.eclipse.vorto.repository.api.content.Constraint;
import org.eclipse.vorto.repository.api.content.ConstraintType;
import org.eclipse.vorto.repository.api.content.EntityModel;
import org.eclipse.vorto.repository.api.content.EnumAttributeProperty;
import org.eclipse.vorto.repository.api.content.EnumAttributePropertyType;
import org.eclipse.vorto.repository.api.content.EnumModel;
import org.eclipse.vorto.repository.api.content.IPropertyAttribute;
import org.eclipse.vorto.repository.api.content.IReferenceType;
import org.eclipse.vorto.repository.api.content.Infomodel;
import org.eclipse.vorto.repository.api.content.ModelEvent;
import org.eclipse.vorto.repository.api.content.ModelProperty;
import org.eclipse.vorto.repository.api.content.Param;
import org.eclipse.vorto.repository.api.content.ReturnType;

/*
 * Exception performing whole class analysis ignored.
 */
public class ModelDtoFactory {
    public static ModelInfo createDto(ModelInfo resource) {
        ModelInfo dto = new ModelInfo(ModelDtoFactory.createDto((ModelId)resource.getId()), ModelType.valueOf((String)resource.getType().name()));
        dto.setAuthor(resource.getAuthor());
        dto.setCreationDate(resource.getCreationDate());
        dto.setDescription(resource.getDescription());
        dto.setDisplayName(resource.getDisplayName());
        dto.setHasImage(resource.isHasImage());
        dto.setReferencedBy(resource.getReferencedBy().stream().map(r -> ModelDtoFactory.createDto((ModelId)r)).collect(Collectors.toList()));
        dto.setReferences(resource.getReferences().stream().map(r -> ModelDtoFactory.createDto((ModelId)r)).collect(Collectors.toList()));
        dto.setSupportedTargetPlatforms(resource.getSupportedTargetPlatforms());
        return dto;
    }

    public static ModelId createDto(ModelId modelId) {
        return new ModelId(modelId.getName(), modelId.getNamespace(), modelId.getVersion());
    }

    public static AbstractModel createResource(Model model) {
        if (model instanceof InformationModel) {
            return ModelDtoFactory.createResource((InformationModel)((InformationModel)model));
        }
        if (model instanceof FunctionblockModel) {
            return ModelDtoFactory.createResource((FunctionblockModel)((FunctionblockModel)model));
        }
        if (model instanceof Entity) {
            return ModelDtoFactory.createResource((Entity)((Entity)model));
        }
        if (model instanceof Enum) {
            return ModelDtoFactory.createResource((Enum)((Enum)model));
        }
        if (model instanceof MappingModel) {
            return new ModelInfo(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Mapping);
        }
        throw new UnsupportedOperationException();
    }

    public static Infomodel createResource(InformationModel model) {
        Infomodel infoResource = new Infomodel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.InformationModel);
        for (FunctionblockProperty property : model.getProperties()) {
            infoResource.getFunctionblocks().add(ModelDtoFactory.createProperty((FunctionblockProperty)property));
        }
        infoResource.setDescription(model.getDescription());
        infoResource.setDisplayName(model.getDisplayname());
        infoResource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId((ModelReference)reference)).collect(Collectors.toList()));
        return infoResource;
    }

    private static ModelId createModelId(Model model) {
        return new ModelId(model.getName(), model.getNamespace(), model.getVersion());
    }

    private static ModelId createModelId(ModelReference reference) {
        ModelId modelId = ModelId.fromReference((String)reference.getImportedNamespace(), (String)reference.getVersion());
        return new ModelId(modelId.getName(), modelId.getNamespace(), modelId.getVersion());
    }

    public static org.eclipse.vorto.repository.api.content.FunctionblockModel createResource(FunctionblockModel model) {
        org.eclipse.vorto.repository.api.content.FunctionblockModel resource = new org.eclipse.vorto.repository.api.content.FunctionblockModel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Functionblock);
        resource.setDescription(model.getDescription());
        resource.setDisplayName(model.getDisplayname());
        resource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId((ModelReference)reference)).collect(Collectors.toList()));
        if (model.getFunctionblock().getConfiguration() != null) {
            resource.setConfigurationProperties(model.getFunctionblock().getConfiguration().getProperties().stream().map(p -> ModelDtoFactory.createProperty((Property)p)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getStatus() != null) {
            resource.setStatusProperties(model.getFunctionblock().getStatus().getProperties().stream().map(p -> ModelDtoFactory.createProperty((Property)p)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getFault() != null) {
            resource.setFaultProperties(model.getFunctionblock().getFault().getProperties().stream().map(p -> ModelDtoFactory.createProperty((Property)p)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getEvents() != null) {
            resource.setEvents(model.getFunctionblock().getEvents().stream().map(e -> ModelDtoFactory.createEvent((Event)e)).collect(Collectors.toList()));
        }
        if (model.getFunctionblock().getOperations() != null) {
            resource.setOperations(model.getFunctionblock().getOperations().stream().map(o -> ModelDtoFactory.createOperation((Operation)o)).collect(Collectors.toList()));
        }
        return resource;
    }

    private static org.eclipse.vorto.repository.api.content.Operation createOperation(Operation o) {
        org.eclipse.vorto.repository.api.content.Operation operation = new org.eclipse.vorto.repository.api.content.Operation();
        operation.setBreakable(o.isBreakable());
        operation.setDescription(o.getDescription());
        operation.setName(o.getName());
        operation.setParams(o.getParams().stream().map(p -> ModelDtoFactory.createParam((org.eclipse.vorto.core.api.model.functionblock.Param)p)).collect(Collectors.toList()));
        if (o.getReturnType() != null) {
            ReturnType returnType = new ReturnType();
            returnType.setMultiple(o.getReturnType().isMultiplicity());
            if (o.getReturnType() instanceof ReturnPrimitiveType) {
                returnType.setPrimitive(true);
                PrimitiveType pt = ((ReturnPrimitiveType)o.getReturnType()).getReturnType();
                returnType.setType((IReferenceType)org.eclipse.vorto.repository.api.content.PrimitiveType.valueOf((String)pt.name()));
            } else {
                returnType.setPrimitive(false);
                returnType.setType((IReferenceType)ModelDtoFactory.createModelId((Model)((ReturnObjectType)o.getReturnType()).getReturnType()));
            }
            operation.setResult(returnType);
        }
        return operation;
    }

    private static Param createParam(org.eclipse.vorto.core.api.model.functionblock.Param p) {
        Param param = new Param();
        param.setDescription(p.getDescription());
        param.setMultiple(p.isMultiplicity());
        param.setName(p.getName());
        if (p instanceof PrimitiveParam) {
            PrimitiveType pt = ((PrimitiveParam)p).getType();
            param.setType((IReferenceType)org.eclipse.vorto.repository.api.content.PrimitiveType.valueOf((String)pt.name()));
            if (((PrimitiveParam)p).getConstraintRule() != null && ((PrimitiveParam)p).getConstraintRule().getConstraints() != null) {
                List constraints = ((PrimitiveParam)p).getConstraintRule().getConstraints().stream().map(c -> ModelDtoFactory.createConstraint((org.eclipse.vorto.core.api.model.datatype.Constraint)c)).collect(Collectors.toList());
                param.setConstraints(constraints);
            }
        } else {
            param.setType((IReferenceType)ModelDtoFactory.createModelId((Model)((RefParam)p).getType()));
        }
        return param;
    }

    private static ModelProperty createProperty(FunctionblockProperty property) {
        ModelProperty p = new ModelProperty();
        p.setDescription(property.getDescription());
        p.setName(property.getName());
        p.setType((IReferenceType)ModelDtoFactory.createModelId((Model)property.getType()));
        return p;
    }

    private static ModelProperty createProperty(Property property) {
        ModelProperty p = new ModelProperty();
        p.setDescription(property.getDescription());
        p.setMandatory(property.getPresence() != null ? property.getPresence().isMandatory() : true);
        p.setMultiple(property.isMultiplicity());
        p.setName(property.getName());
        if (property.getType() instanceof PrimitivePropertyType) {
            PrimitiveType pt = ((PrimitivePropertyType)property.getType()).getType();
            p.setType((IReferenceType)org.eclipse.vorto.repository.api.content.PrimitiveType.valueOf((String)pt.name()));
        } else {
            p.setType((IReferenceType)ModelDtoFactory.createModelId((Model)((ObjectPropertyType)property.getType()).getType()));
        }
        if (property.getConstraintRule() != null && property.getConstraintRule().getConstraints() != null) {
            List constraints = property.getConstraintRule().getConstraints().stream().map(c -> ModelDtoFactory.createConstraint((org.eclipse.vorto.core.api.model.datatype.Constraint)c)).collect(Collectors.toList());
            p.setConstraints(constraints);
        }
        if (property.getPropertyAttributes() != null) {
            List attributes = property.getPropertyAttributes().stream().map(a -> ModelDtoFactory.createAttribute((PropertyAttribute)a)).collect(Collectors.toList());
            p.setAttributes(attributes);
        }
        return p;
    }

    private static IPropertyAttribute createAttribute(PropertyAttribute attribute) {
        if (attribute instanceof BooleanPropertyAttribute) {
            BooleanPropertyAttribute booleanAttribute = (BooleanPropertyAttribute)attribute;
            return new BooleanAttributeProperty(BooleanAttributePropertyType.valueOf((String)booleanAttribute.getType().name()), booleanAttribute.isValue());
        }
        if (attribute instanceof EnumLiteralPropertyAttribute) {
            EnumLiteralPropertyAttribute enumAttribute = (EnumLiteralPropertyAttribute)attribute;
            return new EnumAttributeProperty(EnumAttributePropertyType.valueOf((String)enumAttribute.getType().name()), ModelDtoFactory.createLiteral((EnumLiteral)enumAttribute.getValue()));
        }
        throw new UnsupportedOperationException("Property Attribute cannot be mapped");
    }

    private static Constraint createConstraint(org.eclipse.vorto.core.api.model.datatype.Constraint c) {
        return new Constraint(ConstraintType.valueOf((String)c.getType().name()), c.getConstraintValues());
    }

    private static ModelEvent createEvent(Event event) {
        ModelEvent modelEvent = new ModelEvent();
        modelEvent.setName(event.getName());
        modelEvent.setProperties(event.getProperties().stream().map(p -> ModelDtoFactory.createProperty((Property)p)).collect(Collectors.toList()));
        return modelEvent;
    }

    public static EntityModel createResource(Entity model) {
        EntityModel resource = new EntityModel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Datatype);
        resource.setDescription(model.getDescription());
        resource.setDisplayName(model.getDisplayname());
        resource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId((ModelReference)reference)).collect(Collectors.toList()));
        resource.setProperties(model.getProperties().stream().map(p -> ModelDtoFactory.createProperty((Property)p)).collect(Collectors.toList()));
        return resource;
    }

    public static EnumModel createResource(Enum model) {
        EnumModel resource = new EnumModel(new ModelId(model.getName(), model.getNamespace(), model.getVersion()), ModelType.Datatype);
        resource.setDescription(model.getDescription());
        resource.setDisplayName(model.getDisplayname());
        resource.setReferences(model.getReferences().stream().map(reference -> ModelDtoFactory.createModelId((ModelReference)reference)).collect(Collectors.toList()));
        resource.setLiterals(model.getEnums().stream().map(p -> ModelDtoFactory.createLiteral((EnumLiteral)p)).collect(Collectors.toList()));
        return resource;
    }

    private static org.eclipse.vorto.repository.api.content.EnumLiteral createLiteral(EnumLiteral literal) {
        return new org.eclipse.vorto.repository.api.content.EnumLiteral(literal.getName(), literal.getDescription());
    }
}

