/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.security;

import java.util.Arrays;
import javax.servlet.Filter;
import org.eclipse.vorto.repository.security.AuthorizationTokenFilter;
import org.eclipse.vorto.repository.security.InterceptedUserInfoTokenServices;
import org.eclipse.vorto.repository.security.eidp.EidpOAuth2RestTemplate;
import org.eclipse.vorto.repository.security.eidp.EidpResourceDetails;
import org.eclipse.vorto.repository.security.eidp.Interceptor;
import org.eclipse.vorto.repository.security.eidp.IsEidpUserRegisteredInterceptor;
import org.eclipse.vorto.repository.security.eidp.JwtTokenUserInfoServices;
import org.eclipse.vorto.repository.web.AngularCsrfHeaderFilter;
import org.eclipse.vorto.repository.web.listeners.RESTAuthenticationEntryPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.web.filter.CompositeFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(securedEnabled=true)
@Order(value=0x7FFFFFF8)
@EnableOAuth2Client
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    public static final String LOGIN_TYPE = "loginType";
    @Autowired
    private UserDetailsService userDetailsService;
    @Autowired
    private RESTAuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private OAuth2ClientContext oauth2ClientContext;
    @Autowired
    private EidpResourceDetails eidp;
    @Autowired
    private AuthorizationCodeResourceDetails github;
    @Autowired
    private AccessTokenProvider accessTokenProvider;
    @Autowired
    private IsEidpUserRegisteredInterceptor eidpInterceptor;
    @Autowired
    private InterceptedUserInfoTokenServices interceptedUserInfoTokenServices;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.httpBasic().and()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/rest/**"})).permitAll().antMatchers(new String[]{"/user/**"})).permitAll().antMatchers(HttpMethod.PUT, new String[]{"/rest/**"})).permitAll().antMatchers(HttpMethod.POST, new String[]{"/rest/secure/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{"/rest/**"})).authenticated().and()).addFilterAfter((Filter)new AngularCsrfHeaderFilter(), CsrfFilter.class).addFilterBefore(this.ssoFilter(), BasicAuthenticationFilter.class).addFilterAfter(this.bearerTokenFilter(), SecurityContextPersistenceFilter.class).csrf().csrfTokenRepository(this.csrfTokenRepository()).and()).csrf().disable()).logout().logoutUrl("/logout").logoutSuccessUrl("/").and()).headers().frameOptions().sameOrigin().httpStrictTransportSecurity().disable();
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint);
    }

    private CsrfTokenRepository csrfTokenRepository() {
        HttpSessionCsrfTokenRepository repository = new HttpSessionCsrfTokenRepository();
        repository.setHeaderName("X-XSRF-TOKEN");
        return repository;
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.userDetailsService(this.userDetailsService).passwordEncoder(this.passwordEncoder);
    }

    @Bean
    public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)filter);
        registration.setOrder(-100);
        return registration;
    }

    private Filter bearerTokenFilter() {
        return new AuthorizationTokenFilter((UserInfoTokenServices)this.interceptedUserInfoTokenServices);
    }

    private Filter ssoFilter() {
        CompositeFilter filter = new CompositeFilter();
        filter.setFilters(Arrays.asList(this.githubFilter(), this.eidpFilter()));
        return filter;
    }

    private Filter githubFilter() {
        return this.newSsoFilter("/github/login", (UserInfoTokenServices)this.interceptedUserInfoTokenServices, this.accessTokenProvider, new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)this.github, this.oauth2ClientContext));
    }

    private Filter eidpFilter() {
        JwtTokenUserInfoServices tokenService = new JwtTokenUserInfoServices(null, this.eidp.getClientId(), (Interceptor)this.eidpInterceptor);
        return this.newSsoFilter("/eidp/login", (UserInfoTokenServices)tokenService, this.accessTokenProvider, (OAuth2RestTemplate)new EidpOAuth2RestTemplate(this.eidp, this.oauth2ClientContext));
    }

    private Filter newSsoFilter(String defaultFilterProcessesUrl, UserInfoTokenServices tokenService, AccessTokenProvider accessTokenProvider, OAuth2RestTemplate restTemplate) {
        restTemplate.setAccessTokenProvider(accessTokenProvider);
        OAuth2ClientAuthenticationProcessingFilter filter = new OAuth2ClientAuthenticationProcessingFilter(defaultFilterProcessesUrl);
        tokenService.setRestTemplate((OAuth2RestOperations)restTemplate);
        filter.setRestTemplate((OAuth2RestOperations)restTemplate);
        filter.setTokenServices((ResourceServerTokenServices)tokenService);
        return filter;
    }

    @Bean
    @ConfigurationProperties(value="eidp.oauth2.client")
    public EidpResourceDetails eidp() {
        return new EidpResourceDetails();
    }

    @Bean
    @ConfigurationProperties(value="github.oauth2.client")
    public AuthorizationCodeResourceDetails github() {
        return new AuthorizationCodeResourceDetails();
    }
}

