/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import org.eclipse.vorto.repository.model.Role;

@Entity
public class User {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String firstName;
    private String lastName;
    @Column(unique=true)
    private String username;
    private String email;
    private boolean hasWatchOnRepository;
    @Column(length=60)
    private String password;
    @Column(name="role", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private Role role;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean getHasWatchOnRepository() {
        return this.hasWatchOnRepository;
    }

    public void setHasWatchOnRepository(boolean hasWatchOnRepository) {
        this.hasWatchOnRepository = hasWatchOnRepository;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String username) {
        this.email = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRoles(Role role) {
        this.role = role;
    }

    public String getSalutation() {
        if (this.firstName != null && this.lastName != null) {
            return this.firstName + " " + this.lastName;
        }
        return this.username;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("User [firstName=").append(this.firstName).append("]").append("[lastName=").append(this.lastName).append("]").append("[username=").append(this.username).append("]").append("[email=").append(this.email).append("]").append("[password=").append(this.password).append("]");
        return builder.toString();
    }
}

