/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.validation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.internal.service.validation.CouldNotResolveReferenceException;
import org.eclipse.vorto.repository.internal.service.validation.IModelValidator;
import org.eclipse.vorto.repository.internal.service.validation.ValidationException;
import org.eclipse.vorto.repository.service.IModelRepository;

public class ModelReferencesValidation
implements IModelValidator {
    private IModelRepository modelRepository;

    public ModelReferencesValidation(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void validate(ModelInfo modelResource) throws ValidationException {
        ArrayList missingReferences = new ArrayList();
        if (!modelResource.getReferences().isEmpty()) {
            this.checkReferencesRecursive(modelResource, missingReferences);
        }
        if (!missingReferences.isEmpty()) {
            throw new CouldNotResolveReferenceException(modelResource, missingReferences);
        }
    }

    private void checkReferencesRecursive(ModelInfo modelResource, List<ModelId> accumulator) {
        for (ModelId modelId : modelResource.getReferences()) {
            ModelInfo reference = this.modelRepository.getById(modelId);
            if (reference == null) {
                accumulator.add(modelId);
                continue;
            }
            this.checkReferencesRecursive(reference, accumulator);
        }
    }
}

