/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.internal.service.validation.CouldNotResolveReferenceException;
import org.eclipse.vorto.repository.internal.service.validation.ModelReferencesValidation;
import org.eclipse.vorto.repository.internal.service.validation.ValidationException;
import org.eclipse.vorto.repository.service.IModelRepository;

public class BulkModelReferencesValidation
extends ModelReferencesValidation {
    private List<ModelId> zipModelIds;

    public BulkModelReferencesValidation(IModelRepository modelRepository, Set<ModelInfo> modelResources) {
        super(modelRepository);
        this.zipModelIds = modelResources.stream().map(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
    }

    public void validate(ModelInfo modelResource) throws ValidationException {
        this.validateInRepository(modelResource);
        this.validateInZipFiles(modelResource);
    }

    private List<ModelId> validateInRepository(ModelInfo modelResource) {
        ArrayList<ModelId> missingReferences = new ArrayList<ModelId>();
        try {
            super.validate(modelResource);
        }
        catch (CouldNotResolveReferenceException e) {
            return e.getMissingReferences();
        }
        return missingReferences;
    }

    private boolean isNotInRepository(ModelId modelId) {
        return this.getModelRepository().getById(modelId) == null;
    }

    private void validateInZipFiles(ModelInfo modelResource) {
        List references = modelResource.getReferences();
        ArrayList<ModelId> missingReferences = new ArrayList<ModelId>();
        for (ModelId modelId : references) {
            if (this.zipModelIds.contains(modelId) || !this.isNotInRepository(modelId)) continue;
            missingReferences.add(modelId);
        }
        if (missingReferences.size() > 0) {
            throw new CouldNotResolveReferenceException(modelResource, missingReferences);
        }
    }
}

