/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.internal.service.validation.ModelReferencesValidation;
import org.eclipse.vorto.repository.internal.service.validation.ValidationException;
import org.eclipse.vorto.repository.service.IModelRepository;

public class BulkModelDuplicateIdValidation
extends ModelReferencesValidation {
    private List<ModelId> zipModelIds;

    public BulkModelDuplicateIdValidation(IModelRepository modelRepository, Set<ModelInfo> modelResources) {
        super(modelRepository);
        this.zipModelIds = modelResources.stream().map(new /* Unavailable Anonymous Inner Class!! */).collect(Collectors.toList());
    }

    public void validate(ModelInfo modelResource) throws ValidationException {
        HashSet<ModelId> nonduplicates = new HashSet<ModelId>();
        for (ModelId modelId : this.zipModelIds) {
            if (modelResource.getId().equals((Object)modelId) && nonduplicates.contains(modelId)) {
                throw new ValidationException("Zip contains models with duplicate Ids", modelResource);
            }
            nonduplicates.add(modelId);
        }
    }
}

