/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.vorto.repository.api.ModelId;

public class ModelReferencesHelper {
    private List<ModelId> references = null;

    public ModelReferencesHelper(List<ModelId> references) {
        this.references = references;
    }

    public ModelReferencesHelper() {
        this.references = new ArrayList();
    }

    public String[] getReferencesInPrettyFormat() {
        ArrayList<String> prettyFormatReferences = new ArrayList<String>();
        for (ModelId id : this.references) {
            prettyFormatReferences.add(id.getPrettyFormat());
        }
        return prettyFormatReferences.toArray(new String[prettyFormatReferences.size()]);
    }

    public void addModelReference(String prettyFormat) {
        int versionSeperator = prettyFormat.indexOf(":");
        String qualifiedName = prettyFormat.substring(0, versionSeperator);
        String version = prettyFormat.substring(versionSeperator + 1);
        this.references.add(ModelId.fromReference((String)qualifiedName, (String)version));
    }

    public List<ModelId> getReferences() {
        return this.references;
    }

    public boolean hasReferences() {
        return !this.references.isEmpty();
    }
}

