/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;

public class DependencyManager {
    private Set<ModelInfo> resources = new HashSet();

    public DependencyManager() {
    }

    public DependencyManager(Set<ModelInfo> resources) {
        this.resources = resources;
    }

    public void addResource(ModelInfo resource) {
        this.resources.add(resource);
    }

    public List<ModelInfo> getSorted() {
        ArrayList<ModelInfo> sorted = new ArrayList<ModelInfo>();
        for (ModelInfo resource : this.resources) {
            this.addResourceRecursive(resource, sorted);
        }
        return sorted;
    }

    private void addResourceRecursive(ModelInfo resource, List<ModelInfo> sorted) {
        for (ModelId reference : resource.getReferences()) {
            ModelInfo referencedResource = this.findResource(reference);
            if (referencedResource == null) continue;
            this.addResourceRecursive(referencedResource, sorted);
        }
        if (!sorted.contains(resource)) {
            sorted.add(resource);
        }
    }

    private ModelInfo findResource(ModelId modelId) {
        for (ModelInfo resource : this.resources) {
            if (!resource.getId().equals((Object)modelId)) continue;
            return resource;
        }
        return null;
    }
}

