/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.sequencer;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.internal.service.ModelParserFactory;
import org.eclipse.vorto.repository.internal.service.utils.ModelIdHelper;
import org.eclipse.vorto.repository.internal.service.utils.ModelReferencesHelper;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.springframework.core.io.ClassPathResource;

public class ModelSequencer
extends Sequencer {
    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes(new ClassPathResource("sequencer-model.cnd").getInputStream(), nodeTypeManager, true);
    }

    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        Binary binaryValue = inputProperty.getBinary();
        CheckArg.isNotNull((Object)binaryValue, (String)"binary");
        ModelInfo modelResource = ModelParserFactory.getParser((String)outputNode.getPath()).parse(binaryValue.getStream());
        outputNode.setProperty("vorto:description", modelResource.getDescription() != null ? modelResource.getDescription() : "");
        outputNode.setProperty("vorto:type", modelResource.getType().name());
        outputNode.setProperty("vorto:displayname", modelResource.getDisplayName());
        outputNode.setProperty("vorto:version", modelResource.getId().getVersion());
        outputNode.setProperty("vorto:namespace", modelResource.getId().getNamespace());
        outputNode.setProperty("vorto:name", modelResource.getId().getName());
        ModelReferencesHelper referencesHelper = new ModelReferencesHelper(modelResource.getReferences());
        if (referencesHelper.hasReferences()) {
            ArrayList<Value> references = new ArrayList<Value>();
            for (ModelId modelId : referencesHelper.getReferences()) {
                ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
                Node referencedFolder = outputNode.getSession().getNode(modelIdHelper.getFullPath());
                Node reference = referencedFolder.getNodes().nextNode();
                references.add(context.valueFactory().createValue(reference));
            }
            outputNode.setProperty("vorto:references", references.toArray(new Value[references.size()]));
        }
        return true;
    }
}

