/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.generation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.api.exception.GenerationException;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.api.generation.GeneratedOutput;
import org.eclipse.vorto.repository.api.generation.GeneratorInfo;
import org.eclipse.vorto.repository.api.generation.ServiceClassifier;
import org.eclipse.vorto.repository.internal.service.generation.IGeneratorLookupRepository;
import org.eclipse.vorto.repository.model.Generator;
import org.eclipse.vorto.repository.service.GeneratorAlreadyExistsException;
import org.eclipse.vorto.repository.service.IGeneratorService;
import org.eclipse.vorto.repository.service.IModelRepository;
import org.modeshape.common.collection.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class GenerationDelegateProxyService
implements IGeneratorService {
    @Autowired
    private IGeneratorLookupRepository registeredGeneratorsRepository;
    @Autowired
    private IModelRepository modelRepositoryService;
    private RestTemplate restTemplate = new RestTemplate();
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerationDelegateProxyService.class);

    public void registerGenerator(String serviceKey, String baseUrl, ServiceClassifier classifier) {
        if (!this.registeredGeneratorsRepository.findByGeneratorKey(serviceKey).isEmpty()) {
            throw new GeneratorAlreadyExistsException(serviceKey);
        }
        LOGGER.info("Registered generator {} under base url {} and classifier {}", new Object[]{serviceKey, baseUrl, classifier});
        this.registeredGeneratorsRepository.save((Object)new Generator(serviceKey, baseUrl, classifier.name()));
    }

    public void unregisterGenerator(String serviceKey) {
        Generator generator = this.getGenerator(serviceKey);
        if (generator != null) {
            this.registeredGeneratorsRepository.delete((Object)generator);
        }
    }

    public Set<String> getRegisteredGeneratorServiceKeys(ServiceClassifier classifier) {
        HashSet<String> serviceKeys = new HashSet<String>();
        for (Generator generator : this.registeredGeneratorsRepository.findByClassifier(classifier.name())) {
            serviceKeys.add(generator.getKey());
        }
        return Collections.unmodifiableSet(serviceKeys);
    }

    public GeneratorInfo getGeneratorServiceInfo(String serviceKey, boolean includeConfigUI) {
        Generator generatorEntity = this.getGenerator(serviceKey);
        GeneratorInfo generatorInfo = (GeneratorInfo)this.restTemplate.getForObject(generatorEntity.getGenerationInfoUrl() + "?includeConfigUI={includeConfigUI}", GeneratorInfo.class, new Object[]{includeConfigUI});
        generatorInfo.setInfoUrl(generatorEntity.getGenerationInfoUrl());
        generatorInfo.performRating(generatorEntity.getInvocationCount());
        return generatorInfo;
    }

    public GeneratedOutput generate(ModelId modelId, String serviceKey, Map<String, String> requestParams) {
        ModelInfo modelResource = this.modelRepositoryService.getById(modelId);
        if (modelResource == null) {
            throw new ModelNotFoundException("Model with the given ID does not exist", null);
        }
        if (modelResource.getType() == ModelType.Datatype || modelResource.getType() == ModelType.Mapping) {
            throw new GenerationException("Provided model is neither an information model nor a function block model!");
        }
        this.restTemplate.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        Generator generatorEntity = this.getGenerator(serviceKey);
        if (generatorEntity == null) {
            throw new GenerationException("Generator with key " + serviceKey + " is not a registered generator");
        }
        generatorEntity.increaseInvocationCount();
        this.registeredGeneratorsRepository.save((Object)generatorEntity);
        ResponseEntity entity = this.restTemplate.getForEntity(generatorEntity.getGenerationEndpointUrl() + this.attachRequestParams(requestParams), byte[].class, new Object[]{modelId.getNamespace(), modelId.getName(), modelId.getVersion()});
        return new GeneratedOutput((byte[])entity.getBody(), this.extractFileNameFromHeader(entity), entity.getHeaders().getContentLength());
    }

    private String attachRequestParams(Map<String, String> requestParams) {
        if (requestParams.isEmpty()) {
            return "";
        }
        StringBuilder requestUrlParams = new StringBuilder("?");
        Iterator<String> iter = requestParams.keySet().iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            requestUrlParams.append(key);
            requestUrlParams.append("=");
            requestUrlParams.append(requestParams.get(key));
            if (!iter.hasNext()) continue;
            requestUrlParams.append("&");
        }
        return requestUrlParams.toString();
    }

    private String extractFileNameFromHeader(ResponseEntity<byte[]> entity) {
        List values = entity.getHeaders().get((Object)"content-disposition");
        if (values.size() > 0) {
            int indexOfFileNameStart = ((String)values.get(0)).indexOf("=");
            return ((String)values.get(0)).substring(indexOfFileNameStart + 1);
        }
        return "generated.output";
    }

    private Generator getGenerator(String serviceKey) {
        List generators = this.registeredGeneratorsRepository.findByGeneratorKey(serviceKey);
        if (!generators.isEmpty()) {
            return (Generator)generators.get(0);
        }
        return null;
    }

    public Collection<GeneratorInfo> getMostlyUsedGenerators(int top) {
        ArrayList<Generator> topResult = new ArrayList<Generator>();
        for (Generator entity : this.registeredGeneratorsRepository.findByClassifier(ServiceClassifier.platform.name())) {
            topResult.add(entity);
        }
        topResult.sort((Comparator<Generator>)new /* Unavailable Anonymous Inner Class!! */);
        ArrayList<GeneratorInfo> result = new ArrayList<GeneratorInfo>(top);
        int counter = 0;
        for (Generator entity : topResult) {
            if (counter >= top) continue;
            try {
                result.add(this.getGeneratorServiceInfo(entity.getKey(), false));
                ++counter;
            }
            catch (Throwable t) {
                LOGGER.warn("Generator " + entity.getKey() + " appears to be offline or not deployed. Skipping...");
            }
        }
        return result;
    }
}

