/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.emf;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.vorto.core.api.model.model.Model;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.api.ModelType;
import org.eclipse.vorto.repository.internal.model.ModelEMFResource;
import org.eclipse.vorto.repository.internal.service.IModelParser;
import org.eclipse.vorto.repository.internal.service.validation.ValidationException;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public abstract class AbstractModelParser
implements IModelParser {
    private String fileName;

    public AbstractModelParser(String fileName) {
        this.fileName = fileName;
    }

    public ModelInfo parse(InputStream is) {
        XtextResourceSet resourceSet = (XtextResourceSet)this.getInjector().getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        Resource resource = resourceSet.createResource(URI.createURI((String)("dummy:/" + this.fileName)));
        try {
            resource.load(is, resourceSet.getLoadOptions());
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage(), null);
        }
        List grammarErrors = this.getGrammarErrors(resource.getErrors());
        if (!grammarErrors.isEmpty()) {
            ModelInfo invalidModelResource = new ModelInfo(this.parseModelIdFromFileName(), ModelType.fromFileName((String)this.fileName));
            throw new ValidationException(((Resource.Diagnostic)grammarErrors.get(0)).getMessage(), invalidModelResource);
        }
        return new ModelEMFResource((Model)resource.getContents().get(0));
    }

    private ModelId parseModelIdFromFileName() {
        String pureFileName = this.fileName.substring(this.fileName.lastIndexOf("/") + 1, this.fileName.lastIndexOf("."));
        ModelId modelId = new ModelId();
        try {
            modelId.setNamespace(pureFileName.substring(0, pureFileName.lastIndexOf(".")));
            modelId.setName(pureFileName.substring(pureFileName.lastIndexOf(".") + 1, pureFileName.indexOf("_")));
            String version = pureFileName.substring(pureFileName.indexOf("_") + 1);
            version = version.replaceAll("_", ".");
            modelId.setVersion(version.substring(0, 5));
        }
        catch (Throwable t) {
            return new ModelId(pureFileName, "", "0.0.0");
        }
        return modelId;
    }

    private List<Resource.Diagnostic> getGrammarErrors(EList<Resource.Diagnostic> errors) {
        ArrayList<Resource.Diagnostic> grammarErrors = new ArrayList<Resource.Diagnostic>();
        for (Resource.Diagnostic diagnostic : errors) {
            if (diagnostic instanceof XtextLinkingDiagnostic) continue;
            grammarErrors.add(diagnostic);
        }
        return grammarErrors;
    }

    protected abstract Injector getInjector();
}

