/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service.comment;

import java.util.Date;
import java.util.List;
import javax.jcr.PathNotFoundException;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.exception.ModelNotFoundException;
import org.eclipse.vorto.repository.internal.service.CommentRepository;
import org.eclipse.vorto.repository.model.Comment;
import org.eclipse.vorto.repository.model.User;
import org.eclipse.vorto.repository.service.ICommentService;
import org.eclipse.vorto.repository.service.IModelRepository;
import org.eclipse.vorto.repository.service.IUserRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentService
implements ICommentService {
    @Autowired
    private IModelRepository modelRepository;
    @Autowired
    private CommentRepository commentRepository;
    @Autowired
    private IUserRepository userRepository;

    public void createComment(Comment comment) {
        ModelId id = ModelId.fromPrettyFormat((String)comment.getModelId());
        if (this.modelRepository.getById(id) == null) {
            throw new ModelNotFoundException("Model not found", (Throwable)new PathNotFoundException());
        }
        comment.setModelId(id.getPrettyFormat());
        comment.setDate(new Date());
        this.commentRepository.save((Object)comment);
    }

    public List<Comment> getCommentsforModelId(ModelId modelId) {
        for (Comment comment : this.commentRepository.findByModelId(modelId.getPrettyFormat())) {
            User user = this.userRepository.findByUsername(comment.getAuthor());
            if (user.getFirstName() == null || user.getLastName() == null) continue;
            comment.setFirstname(user.getFirstName());
            comment.setLastname(user.getLastName());
        }
        return this.commentRepository.findByModelId(modelId.getPrettyFormat());
    }
}

