/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.vorto.repository.internal.service.ITemporaryStorage;
import org.eclipse.vorto.repository.internal.service.StorageItem;

public class InMemoryTemporaryStorage
implements ITemporaryStorage {
    private Map<String, StorageItem> storage = new HashMap();
    private static Logger logger = Logger.getLogger(InMemoryTemporaryStorage.class);

    public StorageItem store(String key, Object value, long timeToLiveSeconds) {
        StorageItem newItem = new StorageItem(key, value, new Date(), timeToLiveSeconds);
        this.storage.put(key, newItem);
        logger.info((Object)("Added " + newItem + " in temporary storage"));
        return newItem;
    }

    public StorageItem get(String key) {
        StorageItem item = (StorageItem)this.storage.get(key);
        if (item != null && item.isExpired()) {
            this.remove(key);
            item = null;
        }
        return item;
    }

    public StorageItem remove(String key) {
        logger.info((Object)("Removing " + key + " from temporary storage"));
        return (StorageItem)this.storage.remove(key);
    }

    public void clearExpired() {
        logger.info((Object)"Clearing expired storage items from temporary storage");
        Iterator iter = this.storage.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            StorageItem item = (StorageItem)this.storage.get(key);
            if (!item.isExpired()) continue;
            logger.info((Object)("Removing " + key + " from temporary storage"));
            iter.remove();
        }
    }
}

