/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.internal.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.jcr.Item;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.eclipse.vorto.repository.api.ModelId;
import org.eclipse.vorto.repository.api.ModelInfo;
import org.eclipse.vorto.repository.internal.service.utils.ModelIdHelper;
import org.eclipse.vorto.repository.service.FatalModelRepositoryException;
import org.eclipse.vorto.repository.service.IModelRepository;
import org.eclipse.vorto.repository.service.IRepositoryManager;
import org.eclipse.vorto.repository.service.ModelReferentialIntegrityException;
import org.modeshape.jcr.api.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRepositoryManager
implements IRepositoryManager {
    @Autowired
    private javax.jcr.Session session;
    @Autowired
    private IModelRepository modelRepository;

    public byte[] backup() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((Session)this.session).exportDocumentView("/", (OutputStream)baos, false, false);
        baos.close();
        return baos.toByteArray();
    }

    public void restore(byte[] backup) throws Exception {
        this.removeAll();
        ((Session)this.session).getWorkspace().importXML("/", (InputStream)new ByteArrayInputStream(backup), 0);
    }

    public javax.jcr.Session getSession() {
        return this.session;
    }

    public void setSession(javax.jcr.Session session) {
        this.session = session;
    }

    public IModelRepository getModelRepository() {
        return this.modelRepository;
    }

    public void setModelRepository(IModelRepository modelRepository) {
        this.modelRepository = modelRepository;
    }

    public void removeModel(ModelId modelId) {
        try {
            ModelInfo modelResource = this.modelRepository.getById(modelId);
            if (!modelResource.getReferencedBy().isEmpty()) {
                throw new ModelReferentialIntegrityException("Cannot remove model because it is referenced by other model(s)", modelResource.getReferencedBy());
            }
            ModelIdHelper modelIdHelper = new ModelIdHelper(modelId);
            Item item = this.session.getItem(modelIdHelper.getFullPath());
            item.remove();
            this.session.save();
        }
        catch (RepositoryException e) {
            throw new FatalModelRepositoryException("Problem occured removing the model", (Throwable)e);
        }
    }

    private void removeAll() throws Exception {
        HashSet<String> rootNodes = new HashSet<String>();
        for (ModelInfo resource : this.modelRepository.search("*")) {
            String org = resource.getId().getNamespace().substring(0, resource.getId().getNamespace().indexOf("."));
            rootNodes.add(org);
        }
        for (String rootNode : rootNodes) {
            try {
                Item item = this.session.getItem("/" + rootNode);
                item.remove();
            }
            catch (PathNotFoundException pathNotFoundException) {}
        }
        this.session.save();
    }
}

