/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.eclipse.vorto.repository.internal.service.ITemporaryStorage;
import org.eclipse.vorto.repository.internal.service.InMemoryTemporaryStorage;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@SpringBootApplication
@EnableSwagger2
@EnableJpaRepositories
@EnableScheduling
public class VortoRepository {
    public static void main(String[] args) {
        SpringApplication.run(VortoRepository.class, (String[])args);
    }

    @Bean
    public ITemporaryStorage createTempStorage() {
        return new InMemoryTemporaryStorage();
    }

    @Bean
    public Docket vortoApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).useDefaultResponseMessages(false).select().paths(this.paths()).build();
    }

    private Predicate<String> paths() {
        return Predicates.or((Predicate[])new Predicate[]{PathSelectors.regex((String)"/rest/secure.*"), PathSelectors.regex((String)"/rest/model.*"), PathSelectors.regex((String)"/rest/resolver.*"), PathSelectors.regex((String)"/rest/generation-router.*")});
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Vorto", "Vorto is an open source tool that allows to create and manage technology agnostic, abstract device descriptions, so called information models. <br/>Information models describe the attributes and the capabilities of real world devices. <br/>These information models can be managed and shared within the Vorto Information Model Repository. <br/> Code Generators for Information Models let you integrate devices into different platforms.<br/>", "1.0.0", "", "Eclipse Vorto Team", "EPL", "https://eclipse.org/org/documents/epl-v10.php");
    }

    @Bean
    public static PasswordEncoder encoder() {
        return new BCryptPasswordEncoder(11);
    }
}

