/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vorto.repository.oauth.IOAuthFlowConfiguration;
import org.eclipse.vorto.repository.oauth.IOAuthProviderRegistry;
import org.eclipse.vorto.repository.oauth.internal.filter.BearerTokenFilter;
import org.eclipse.vorto.repository.server.config.config.MyAnonymousAuthFilter;
import org.eclipse.vorto.repository.web.ui.AngularCsrfHeaderFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.filter.OrderedHttpPutFormContentFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CompositeFilter;

@Configuration
@EnableWebSecurity
@Order(value=0x7FFFFFF8)
@EnableOAuth2Client
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger LOGGER = Logger.getLogger(SecurityConfiguration.class.getCanonicalName());
    private static final Pattern UNSAFE_CORS_PATTERNS = Pattern.compile("\\.([+?*]+|\\{.+?,\\})");
    @Autowired
    private List<IOAuthFlowConfiguration> oauthProviders;
    @Autowired
    private org.eclipse.vorto.repository.web.listeners.AuthenticationEntryPoint authenticationEntryPoint;
    @Value(value="${server.config.generatorUser}")
    private String generatorUser = "";
    @Value(value="${server.config.generatorPassword}")
    private String generatorUserPassword = "";
    @Value(value="${server.config.cors.allowedOrigins}")
    private String allowedOrigins;
    @Autowired
    private IOAuthProviderRegistry oauthProviderRegistry;
    @Autowired
    private Environment env;
    private static final String ROLE_GENERATOR_PROVIDER = "GENERATOR_PROVIDER";

    @Bean
    public OrderedHttpPutFormContentFilter httpPutFormContentFilter() {
        return new OrderedHttpPutFormContentFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        };
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.httpBasic().and()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/rest/**", "/api/**"})).permitAll().antMatchers(new String[]{"/user/**"})).permitAll().antMatchers(HttpMethod.PUT, new String[]{"/rest/**", "/api/**"})).authenticated().antMatchers(HttpMethod.POST, new String[]{"/rest/**", "/api/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{"/rest/**", "/api/**"})).authenticated().and()).addFilterAfter((Filter)new AngularCsrfHeaderFilter(), CsrfFilter.class).addFilterAfter(this.anonymousFilter(), AnonymousAuthenticationFilter.class).addFilterBefore(this.ssoFilter(), BasicAuthenticationFilter.class).addFilterAfter(this.bearerTokenFilter(), SecurityContextPersistenceFilter.class).csrf().csrfTokenRepository(this.csrfTokenRepository()).and()).csrf().disable()).logout().logoutUrl("/logout").logoutSuccessUrl("/").and()).headers().frameOptions().sameOrigin();
        if (this.isCloudProfile()) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
        }
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint);
        http.cors().configurationSource(this.corsConfigurationSource());
    }

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration(){

            public String checkOrigin(String requestOrigin) {
                String result = super.checkOrigin(requestOrigin);
                if (result != null) {
                    return result;
                }
                for (String ao : super.getAllowedOrigins()) {
                    try {
                        if (!Pattern.compile(ao).matcher(requestOrigin).find()) continue;
                        return requestOrigin;
                    }
                    catch (PatternSyntaxException pse) {
                    }
                }
                return null;
            }
        };
        List<String> allowedOriginsAsList = Arrays.asList(this.allowedOrigins.split(",\\s*"));
        for (String origin : allowedOriginsAsList) {
            if (!UNSAFE_CORS_PATTERNS.matcher(origin).matches()) continue;
            LOGGER.warning(String.format("Unsafe CORS allowed origin [%s] - the Vorto repository may be insecure.", origin));
        }
        configuration.setAllowedOrigins(allowedOriginsAsList);
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "PUT", "DELETE", "OPTIONS"));
        configuration.setAllowCredentials(Boolean.valueOf(true));
        configuration.setAllowedHeaders(Arrays.asList("Access-Control-Request-Method", "Access-Control-Request-Headers", "authorization", "content-type", "x-auth-token"));
        configuration.setExposedHeaders(Arrays.asList("Access-Control-Allow-Origin", "Access-Control-Allow-Methods", "Access-Control-Max-Age", "x-auth-token"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    private boolean isCloudProfile() {
        return this.env.acceptsProfiles(new String[]{"prod", "int"});
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser(this.generatorUser).password(this.generatorUserPassword).roles(new String[]{ROLE_GENERATOR_PROVIDER});
    }

    @Bean
    public Filter anonymousFilter() {
        return new MyAnonymousAuthFilter();
    }

    @Bean
    public static PasswordEncoder encoder() {
        return new BCryptPasswordEncoder(11);
    }

    private CsrfTokenRepository csrfTokenRepository() {
        HttpSessionCsrfTokenRepository repository = new HttpSessionCsrfTokenRepository();
        repository.setHeaderName("X-XSRF-TOKEN");
        return repository;
    }

    @Bean
    public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)filter);
        registration.setOrder(-100);
        return registration;
    }

    private Filter bearerTokenFilter() {
        return new BearerTokenFilter(this.oauthProviderRegistry);
    }

    private Filter ssoFilter() {
        CompositeFilter filter = new CompositeFilter();
        ArrayList ssoFilters = new ArrayList(this.oauthProviders.size());
        this.oauthProviders.forEach(provider -> ssoFilters.add(provider.createFilter()));
        filter.setFilters(ssoFilters);
        return filter;
    }
}

