/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.vorto.repository.core.IModelRepositoryFactory;
import org.eclipse.vorto.repository.oauth.internal.TokenUtils;
import org.eclipse.vorto.repository.repositories.NamespaceRepository;
import org.eclipse.vorto.repository.search.impl.SimpleSearchService;
import org.eclipse.vorto.repository.server.config.config.BaseConfiguration;
import org.eclipse.vorto.repository.utils.LoggingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.converter.ByteArrayHttpMessageConverter;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.web.client.RestTemplate;

@Configuration
public class RepositoryConfiguration
extends BaseConfiguration {
    @Value(value="${http.proxyHost:#{null}}")
    private String proxyHost;
    @Value(value="${http.proxyPort:8080}")
    protected int proxyPort;
    @Value(value="${http.proxyUser:#{null}}")
    private String proxyUsername;
    @Value(value="${http.proxyPassword:#{null}}")
    private String proxyPassword;
    @Value(value="${repo.configFile}")
    private String repositoryConfigFile = null;

    @Bean
    public org.modeshape.jcr.RepositoryConfiguration repoConfiguration() throws Exception {
        return org.modeshape.jcr.RepositoryConfiguration.read((URL)new ClassPathResource(this.repositoryConfigFile).getURL());
    }

    @Bean
    public AccessTokenProvider accessTokenProvider() {
        if (this.proxyHost != null && this.proxyUsername != null) {
            return TokenUtils.proxiedAccessTokenProvider((String)this.proxyHost, (int)this.proxyPort, (String)this.proxyUsername, (String)this.proxyPassword);
        }
        if (this.proxyHost != null && this.proxyUsername == null) {
            return TokenUtils.proxiedAccessTokenProvider((String)this.proxyHost, (int)this.proxyPort);
        }
        return TokenUtils.accessTokenProvider();
    }

    @Bean
    @Profile(value={"local", "test", "local-test", "local-ui-test", "local-https", "local-dev-simplesearch"})
    public SimpleSearchService simpleSearch(@Autowired NamespaceRepository namespaceRepository, @Autowired IModelRepositoryFactory repositoryFactory) {
        return new SimpleSearchService(namespaceRepository, repositoryFactory);
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory()));
        ArrayList<LoggingInterceptor> interceptors = new ArrayList<LoggingInterceptor>();
        interceptors.add(new LoggingInterceptor());
        restTemplate.setInterceptors(interceptors);
        restTemplate.getMessageConverters().add(new ByteArrayHttpMessageConverter());
        return restTemplate;
    }
}

