/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config;

import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.vorto.repository.server.config.config.MyAnonymousAuthFilter;
import org.eclipse.vorto.repository.sso.AuthorizationTokenFilter;
import org.eclipse.vorto.repository.sso.InterceptedUserInfoTokenServices;
import org.eclipse.vorto.repository.sso.boschid.EidpOAuth2RestTemplate;
import org.eclipse.vorto.repository.sso.boschid.EidpPrincipalExtractor;
import org.eclipse.vorto.repository.sso.boschid.EidpResourceDetails;
import org.eclipse.vorto.repository.sso.oauth.SimpleUserInfoServices;
import org.eclipse.vorto.repository.web.listeners.AuthenticationSuccessHandler;
import org.eclipse.vorto.repository.web.security.UserDBAuthoritiesExtractor;
import org.eclipse.vorto.repository.web.tenant.TenantVerificationFilter;
import org.eclipse.vorto.repository.web.ui.AngularCsrfHeaderFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.security.oauth2.resource.AuthoritiesExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.PrincipalExtractor;
import org.springframework.boot.autoconfigure.security.oauth2.resource.UserInfoTokenServices;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.filter.OrderedHttpPutFormContentFilter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestOperations;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.filter.OAuth2ClientContextFilter;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.csrf.CsrfFilter;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.HttpSessionCsrfTokenRepository;
import org.springframework.web.filter.CompositeFilter;

@Configuration
@EnableWebSecurity
@Order(value=0x7FFFFFF8)
@EnableOAuth2Client
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Autowired
    private org.eclipse.vorto.repository.web.listeners.AuthenticationEntryPoint authenticationEntryPoint;
    @Autowired
    private AuthenticationSuccessHandler successHandler;
    @Autowired
    private OAuth2ClientContext oauth2ClientContext;
    @Autowired
    @Qualifier(value="githubUserInfoTokenService")
    private InterceptedUserInfoTokenServices interceptedUserInfoTokenServices;
    @Autowired
    @Qualifier(value="simpleUserInfoServices")
    private SimpleUserInfoServices simpleUserInfoService;
    @Autowired
    private EidpResourceDetails eidp;
    @Value(value="${github.oauth2.resource.userInfoUri}")
    private String githubUserInfoEndpointUrl;
    @Value(value="${eidp.oauth2.resource.userInfoUri}")
    private String eidpUserInfoEndpointUrl;
    @Value(value="${github.oauth2.enabled}")
    private boolean githubEnabled = false;
    @Value(value="${server.config.generatorUser}")
    private String generatorUser = "";
    @Value(value="${server.config.generatorPassword}")
    private String generatorUserPassword = "";
    @Autowired
    private AuthorizationCodeResourceDetails github;
    @Autowired
    private AccessTokenProvider accessTokenProvider;
    @Autowired
    private TenantVerificationFilter tenantVerificationFilter;
    @Autowired
    private Environment env;
    private static final String ROLE_GENERATOR_PROVIDER = "GENERATOR_PROVIDER";

    @Bean
    public OrderedHttpPutFormContentFilter httpPutFormContentFilter() {
        return new OrderedHttpPutFormContentFilter(){

            protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        };
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.httpBasic().and()).authorizeRequests().antMatchers(HttpMethod.GET, new String[]{"/rest/**", "/api/**"})).permitAll().antMatchers(new String[]{"/user/**"})).permitAll().antMatchers(HttpMethod.PUT, new String[]{"/rest/**", "/api/**"})).authenticated().antMatchers(HttpMethod.POST, new String[]{"/rest/**", "/api/**"})).authenticated().antMatchers(HttpMethod.DELETE, new String[]{"/rest/**", "/api/**"})).authenticated().and()).addFilterAfter((Filter)new AngularCsrfHeaderFilter(), CsrfFilter.class).addFilterAfter(this.anonymousFilter(), AnonymousAuthenticationFilter.class).addFilterBefore(this.ssoFilter(), BasicAuthenticationFilter.class).addFilterAfter(this.bearerTokenFilter(), SecurityContextPersistenceFilter.class).addFilterAfter((Filter)this.tenantVerificationFilter, SecurityContextPersistenceFilter.class).csrf().csrfTokenRepository(this.csrfTokenRepository()).and()).csrf().disable()).logout().logoutUrl("/logout").logoutSuccessUrl("/").and()).headers().frameOptions().sameOrigin();
        if (this.isCloudProfile()) {
            ((ChannelSecurityConfigurer.RequiresChannelUrl)http.requiresChannel().anyRequest()).requiresSecure();
        }
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint);
    }

    private boolean isCloudProfile() {
        return this.env.acceptsProfiles(new String[]{"prod", "int"});
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.inMemoryAuthentication().withUser(this.generatorUser).password(this.generatorUserPassword).roles(new String[]{ROLE_GENERATOR_PROVIDER});
    }

    @Bean
    public Filter anonymousFilter() {
        return new MyAnonymousAuthFilter();
    }

    @Bean
    public static PasswordEncoder encoder() {
        return new BCryptPasswordEncoder(11);
    }

    private CsrfTokenRepository csrfTokenRepository() {
        HttpSessionCsrfTokenRepository repository = new HttpSessionCsrfTokenRepository();
        repository.setHeaderName("X-XSRF-TOKEN");
        return repository;
    }

    @Bean
    public FilterRegistrationBean oauth2ClientFilterRegistration(OAuth2ClientContextFilter filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)filter);
        registration.setOrder(-100);
        return registration;
    }

    private Filter bearerTokenFilter() {
        if (this.githubEnabled) {
            return new AuthorizationTokenFilter((UserInfoTokenServices)this.interceptedUserInfoTokenServices);
        }
        return new AuthorizationTokenFilter((UserInfoTokenServices)this.simpleUserInfoService);
    }

    private Filter ssoFilter() {
        CompositeFilter filter = new CompositeFilter();
        filter.setFilters(Arrays.asList(this.githubFilter(), this.eidpFilter()));
        return filter;
    }

    private Filter githubFilter() {
        return this.newSsoFilter("/github/login", (UserInfoTokenServices)this.interceptedUserInfoTokenServices, this.accessTokenProvider, new OAuth2RestTemplate((OAuth2ProtectedResourceDetails)this.github, this.oauth2ClientContext), this.authoritiesExtractor("login"));
    }

    private Filter eidpFilter() {
        SimpleUserInfoServices userInfoService = new SimpleUserInfoServices(this.eidpUserInfoEndpointUrl, this.eidp);
        userInfoService.setPrincipalExtractor((PrincipalExtractor)new EidpPrincipalExtractor());
        return this.newSsoFilter("/eidp/login", (UserInfoTokenServices)userInfoService, this.accessTokenProvider, (OAuth2RestTemplate)new EidpOAuth2RestTemplate(this.eidp, this.oauth2ClientContext), this.authoritiesExtractor("sub"));
    }

    private Filter newSsoFilter(String defaultFilterProcessesUrl, UserInfoTokenServices tokenService, AccessTokenProvider accessTokenProvider, OAuth2RestTemplate restTemplate, AuthoritiesExtractor authoritiesExtractor) {
        restTemplate.setAccessTokenProvider(accessTokenProvider);
        OAuth2ClientAuthenticationProcessingFilter filter = new OAuth2ClientAuthenticationProcessingFilter(defaultFilterProcessesUrl);
        filter.setAuthenticationSuccessHandler((org.springframework.security.web.authentication.AuthenticationSuccessHandler)this.successHandler);
        tokenService.setRestTemplate((OAuth2RestOperations)restTemplate);
        tokenService.setAuthoritiesExtractor(authoritiesExtractor);
        filter.setRestTemplate((OAuth2RestOperations)restTemplate);
        filter.setTokenServices((ResourceServerTokenServices)tokenService);
        return filter;
    }

    @Bean
    @Scope(value="prototype")
    public AuthoritiesExtractor authoritiesExtractor(String userAttributeId) {
        return new UserDBAuthoritiesExtractor(userAttributeId);
    }

    @Bean
    @ConfigurationProperties(value="eidp.oauth2.client")
    public EidpResourceDetails eidp() {
        return new EidpResourceDetails();
    }

    @Bean
    @ConfigurationProperties(value="github.oauth2.client")
    public AuthorizationCodeResourceDetails github() {
        return new AuthorizationCodeResourceDetails();
    }
}

