/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.UriComponentsBuilder;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.paths.AbstractPathProvider;
import springfox.documentation.spring.web.paths.Paths;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
@Configuration
public class SwaggerConfiguration {
    @Value(value="${spring.profiles.active:#{null}}")
    private String activeProfile;

    @Bean
    public Docket vortoApi() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).useDefaultResponseMessages(false).select().paths(this.paths()).build();
        if (this.activeProfile != null && !this.activeProfile.contains("local") && !this.activeProfile.contains("local-https")) {
            docket.pathProvider((PathProvider)new BasePathAwareRelativePathProvider(""));
        }
        return docket;
    }

    private Predicate<String> paths() {
        return Predicates.or((Predicate[])new Predicate[]{PathSelectors.regex((String)"/api/v1/models.*"), PathSelectors.regex((String)"/api/v1/search.*"), PathSelectors.regex((String)"/api/v1/generators.*"), PathSelectors.regex((String)"/api/v1/plugins.*"), PathSelectors.regex((String)"/api/v1/attachments.*")});
    }

    private ApiInfo apiInfo() {
        return new ApiInfo("Swagger Vorto API", "Documentation of public API (JSON Model Request/Response, Examples, ...)", "V1", "https://www.eclipse.org/legal/termsofuse.php", "Eclipse Vorto Team", "EPL", "https://www.eclipse.org/legal/epl-2.0");
    }

    class BasePathAwareRelativePathProvider
    extends AbstractPathProvider {
        private String basePath;

        public BasePathAwareRelativePathProvider(String basePath) {
            this.basePath = basePath;
        }

        protected String applicationPath() {
            return this.basePath;
        }

        protected String getDocumentationPath() {
            return "/";
        }

        public String getOperationPath(String operationPath) {
            UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromPath((String)"");
            return Paths.removeAdjacentForwardSlashes((String)uriComponentsBuilder.path(operationPath.replaceFirst(this.basePath, "")).build().toString());
        }
    }
}

