/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.server.config.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.eclipse.vorto.model.BooleanAttributeProperty;
import org.eclipse.vorto.model.EnumAttributeProperty;
import org.eclipse.vorto.model.IPropertyAttribute;
import org.eclipse.vorto.model.IReferenceType;
import org.eclipse.vorto.model.ModelId;
import org.eclipse.vorto.model.PrimitiveType;
import org.springframework.context.annotation.Bean;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public class BaseConfiguration {
    @Bean
    public Jackson2ObjectMapperBuilder objectMapperBuilder() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.deserializerByType(IReferenceType.class, (JsonDeserializer)new JsonDeserializer<IReferenceType>(){

            public IReferenceType deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
                try {
                    return (IReferenceType)parser.readValueAs(ModelId.class);
                }
                catch (IOException ioEx) {
                    try {
                        return (IReferenceType)parser.readValueAs(PrimitiveType.class);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
            }
        });
        builder.deserializerByType(IPropertyAttribute.class, (JsonDeserializer)new JsonDeserializer<IPropertyAttribute>(){

            public IPropertyAttribute deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
                try {
                    return (IPropertyAttribute)parser.readValueAs(BooleanAttributeProperty.class);
                }
                catch (IOException ioEx) {
                    try {
                        return (IPropertyAttribute)parser.readValueAs(EnumAttributeProperty.class);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        return null;
                    }
                }
            }
        });
        return builder;
    }
}

